/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

record StepUpAuthenticationPolicy(String[] expectedAcrValues, Long maxAge) implements Consumer<TokenVerificationResult>
{
    private static volatile boolean enabled = false;
    private static final Logger LOG = Logger.getLogger(StepUpAuthenticationPolicy.class);
    private static final String AUTHENTICATION_POLICY_KEY = "io.quarkus.oidc.runtime.step-up-auth";

    StepUpAuthenticationPolicy(String acrValues, Duration maxAge) {
        this(StepUpAuthenticationPolicy.splitAcrValues(acrValues), maxAge == null ? null : Long.valueOf(maxAge.toSeconds()));
    }

    @Override
    public void accept(TokenVerificationResult t) {
        JsonObject json = t.localVerificationResult != null ? t.localVerificationResult : new JsonObject(t.introspectionResult.getIntrospectionString());
        this.verifyAcr(json);
        if (this.maxAge != null) {
            this.verifyMaxAge(json);
        }
    }

    private void verifyMaxAge(JsonObject json) {
        Long authTime = json.getLong(Claims.auth_time.name());
        if (authTime == null && (authTime = json.getLong(Claims.iat.name())) != null) {
            LOG.debugf("The '%s' claim value is not available, using the '%s' claim value '%s' to verify maximum token age", (Object)Claims.auth_time.name(), (Object)Claims.iat.name(), (Object)authTime);
        }
        if (authTime != null) {
            long nowSecs = System.currentTimeMillis() / 1000L;
            if (nowSecs - authTime > this.maxAge) {
                this.throwAuthenticationFailedException("The token age '%d' has exceeded '%d'".formatted(authTime + this.maxAge, nowSecs));
            }
        } else {
            this.throwAuthenticationFailedException("Token has no '%s' claim".formatted(Claims.auth_time.name()));
        }
    }

    private void verifyAcr(JsonObject json) {
        Object acrObject = json.getValue("acr");
        if (acrObject != null) {
            JsonArray acr;
            if (acrObject instanceof JsonArray && !(acr = (JsonArray)acrObject).isEmpty()) {
                boolean acrFound = true;
                for (String expectedAcrValue : this.expectedAcrValues) {
                    if (acr.contains((Object)expectedAcrValue)) continue;
                    LOG.debug((Object)("Acr value " + expectedAcrValue + " is required but not found in token 'acr' claim: " + String.valueOf(acr)));
                    acrFound = false;
                    break;
                }
                if (acrFound) {
                    return;
                }
            } else if (this.expectedAcrValues.length == 1 && this.expectedAcrValues[0].equals(acrObject)) {
                return;
            }
        }
        String message = "Valid token with '%s' acr claim values is required".formatted(Arrays.toString(this.expectedAcrValues));
        this.throwAuthenticationFailedException(message);
    }

    private void throwAuthenticationFailedException(String exceptionMessage) {
        StepUpAuthenticationPolicy.throwAuthenticationFailedException(exceptionMessage, this.expectedAcrValues, this.maxAge);
    }

    private static void throwAuthenticationFailedException(String exceptionMessage, String[] expectedAcrValues, Long maxAge) {
        Map<String, String> failureContext = maxAge == null ? Map.of("acr_values", String.join((CharSequence)",", expectedAcrValues)) : Map.of("acr_values", String.join((CharSequence)",", expectedAcrValues), "max_age", Long.toString(maxAge));
        throw new AuthenticationFailedException(exceptionMessage, failureContext);
    }

    static void throwAuthenticationFailedException(String exceptionMessage, Set<String> expectedAcrValues) {
        StepUpAuthenticationPolicy.throwAuthenticationFailedException(exceptionMessage, expectedAcrValues.toArray(new String[0]), null);
    }

    void storeSelfOnContext(RoutingContext routingContext) {
        routingContext.put(AUTHENTICATION_POLICY_KEY, (Object)this);
    }

    static StepUpAuthenticationPolicy getFromRequest(TokenAuthenticationRequest request) {
        RoutingContext routingContext = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
        return routingContext != null ? (StepUpAuthenticationPolicy)routingContext.get(AUTHENTICATION_POLICY_KEY) : null;
    }

    static boolean isInsufficientUserAuthException(RoutingContext routingContext) {
        AuthenticationFailedException authFailure = HttpSecurityUtils.getAuthenticationFailureFromEvent((RoutingContext)routingContext);
        return StepUpAuthenticationPolicy.isInsufficientUserAuthException(authFailure);
    }

    static String getAuthRequirementChallenge(RoutingContext context) {
        AuthenticationFailedException authFailure = HttpSecurityUtils.getAuthenticationFailureFromEvent((RoutingContext)context);
        if (StepUpAuthenticationPolicy.isInsufficientUserAuthException(authFailure)) {
            StringBuilder challengeBuilder = new StringBuilder(" error=\"insufficient_user_authentication\", error_description=\"A different authentication level is required\"");
            if (authFailure.getAttribute("acr_values") != null) {
                challengeBuilder.append(", ").append("acr_values").append("=\"").append((String)authFailure.getAttribute("acr_values")).append("\"");
            }
            if (authFailure.getAttribute("max_age") != null) {
                challengeBuilder.append(", ").append("max_age").append("=\"").append((String)authFailure.getAttribute("max_age")).append("\"");
            }
            return challengeBuilder.toString();
        }
        return null;
    }

    private static boolean isInsufficientUserAuthException(AuthenticationFailedException authFailure) {
        return authFailure != null && (authFailure.getAttribute("acr_values") != null || authFailure.getAttribute("max_age") != null);
    }

    static void markAsEnabled() {
        enabled = true;
    }

    static boolean isEnabled() {
        return enabled;
    }

    private static String[] splitAcrValues(String acrValues) {
        String[] acrValuesArr = acrValues.split(",");
        if (acrValuesArr.length > 1) {
            return (String[])Set.of(acrValuesArr).toArray(String[]::new);
        }
        return acrValuesArr;
    }
}

