/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common;

import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;

public interface OidcRequestFilter {
    default public void filter(OidcRequestContext requestContext) {
        this.filter(requestContext.request(), requestContext.requestBody(), requestContext.contextProperties());
    }

    @Deprecated(forRemoval=true)
    default public void filter(HttpRequest<Buffer> request, Buffer requestBody, OidcRequestContextProperties contextProperties) {
        throw new UnsupportedOperationException("filter(HttpRequest<Buffer> request, Buffer requestBody, OidcRequestContextProperties contextProperties) method is not implemented");
    }

    public static class OidcRequestContext {
        final HttpRequest<Buffer> request;
        final OidcRequestContextProperties contextProperties;
        Buffer requestBody;

        public OidcRequestContext(HttpRequest<Buffer> request, Buffer requestBody, OidcRequestContextProperties contextProperties) {
            this.request = request;
            this.requestBody = requestBody;
            this.contextProperties = contextProperties;
        }

        public HttpRequest<Buffer> request() {
            return this.request;
        }

        public Buffer requestBody() {
            return this.requestBody;
        }

        public OidcRequestContextProperties contextProperties() {
            return this.contextProperties;
        }

        public void requestBody(Buffer buffer) {
            this.requestBody = buffer;
            this.contextProperties.put(OidcRequestContextProperties.REQUEST_BODY, buffer);
        }
    }
}

