/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.nosql.async.vertx;

import com.google.common.base.Preconditions;
import io.vertx.core.Vertx;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.polaris.nosql.async.AsyncConfiguration;
import org.apache.polaris.nosql.async.AsyncExec;
import org.apache.polaris.nosql.async.Cancelable;
import org.apache.polaris.nosql.async.vertx.VertxAsyncExec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class VertxAsyncExec
implements AsyncExec,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VertxAsyncExec.class.getName());
    private static final Duration MAX_DURATION = Duration.ofDays(7L);
    public static final String EXECUTOR_THREAD_NAME_PREFIX = "VertxAsyncExec#";
    private final ThreadPoolExecutor executorService;
    private final Vertx vertx;
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    private final int poolId;
    private final AtomicInteger executorThreadId;
    private volatile boolean shutdown;
    private final Set<CancelableFuture<?>> tasks;

    @Inject
    VertxAsyncExec(Vertx vertx, AsyncConfiguration asyncConfiguration) {
        this.poolId = POOL_ID.incrementAndGet();
        this.executorThreadId = new AtomicInteger();
        this.tasks = ConcurrentHashMap.newKeySet();
        this.vertx = vertx;
        this.executorService = new ThreadPoolExecutor(0, asyncConfiguration.maxThreads().orElse(AsyncConfiguration.DEFAULT_MAX_THREADS), asyncConfiguration.threadKeepAlive().orElse(AsyncConfiguration.DEFAULT_THREAD_KEEP_ALIVE).toMillis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread t = new Thread(r, EXECUTOR_THREAD_NAME_PREFIX + this.poolId + "-" + this.executorThreadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }, (r, executor) -> {
            Future future = null;
            if (r instanceof CancelableFuture) {
                CancelableFuture cancelable = (CancelableFuture)r;
                cancelable.cancelTimer();
                future = cancelable.completable;
            } else if (r instanceof Future) {
                Future f;
                future = f = (Future)((Object)r);
            }
            if (future != null && future.isDone()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(this.rejectedMessage(r, executor));
                }
                return;
            }
            String msg = this.rejectedMessage(r, executor);
            RejectedExecutionException ex = new RejectedExecutionException(msg);
            LOGGER.error(msg);
            throw ex;
        });
        this.executorService.allowCoreThreadTimeOut(true);
        LOGGER.debug("VertxAsyncExec initialized with pool ID {}", (Object)this.poolId);
    }

    private String rejectedMessage(Runnable r, ThreadPoolExecutor executor) {
        return String.format("Runnable '%s' rejected against pool ID %s / '%s'", r, this.poolId, executor);
    }

    @Override
    @PreDestroy
    public void close() {
        this.shutdown = true;
        LOGGER.debug("Shutting down VertxAsyncExec {} / '{}'", (Object)this.poolId, (Object)this.executorService);
        this.tasks.forEach(CancelableFuture::cancel);
        this.tasks.clear();
        this.executorService.shutdownNow();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    public <R> Cancelable<R> schedule(Callable<R> callable, Duration delay) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (String)"Must not schedule new tasks after shutdown of pool %s", (int)this.poolId);
        Preconditions.checkArgument((delay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Delay is limited to %s", (Object)MAX_DURATION);
        CancelableFuture cf = new CancelableFuture(this, callable, Math.max(delay.toMillis(), 0L));
        this.tasks.add(cf);
        return cf;
    }

    public Cancelable<Void> schedulePeriodic(Runnable runnable, Duration initialDelay, Duration delay) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (String)"Must not schedule new tasks after shutdown of pool %s", (int)this.poolId);
        Preconditions.checkArgument((boolean)delay.isPositive(), (Object)"Delay must not be zero or negative");
        Preconditions.checkArgument((initialDelay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Initial delay is limited to %s", (Object)MAX_DURATION);
        Preconditions.checkArgument((delay.compareTo(MAX_DURATION) < 0 ? 1 : 0) != 0, (String)"Delay is limited to %s", (Object)MAX_DURATION);
        CancelableFuture cf = new CancelableFuture(this, runnable, Math.max(initialDelay.toMillis(), 0L), Math.max(delay.toMillis(), 1L));
        this.tasks.add(cf);
        return cf;
    }

    public String toString() {
        return "VertxAsyncExec with pool ID " + this.poolId + " backed by " + String.valueOf(this.executorService);
    }

    public VertxAsyncExec() {
    }
}

