/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.storage.v2.BidiReadObjectRequest;
import com.google.storage.v2.BidiReadObjectResponse;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.Bucket;
import com.google.storage.v2.BucketName;
import com.google.storage.v2.CancelResumableWriteRequest;
import com.google.storage.v2.CancelResumableWriteResponse;
import com.google.storage.v2.ComposeObjectRequest;
import com.google.storage.v2.CreateBucketRequest;
import com.google.storage.v2.DeleteBucketRequest;
import com.google.storage.v2.DeleteObjectRequest;
import com.google.storage.v2.GetBucketRequest;
import com.google.storage.v2.GetObjectRequest;
import com.google.storage.v2.ListBucketsRequest;
import com.google.storage.v2.ListBucketsResponse;
import com.google.storage.v2.ListObjectsRequest;
import com.google.storage.v2.ListObjectsResponse;
import com.google.storage.v2.LockBucketRetentionPolicyRequest;
import com.google.storage.v2.MoveObjectRequest;
import com.google.storage.v2.Object;
import com.google.storage.v2.ProjectName;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.RestoreObjectRequest;
import com.google.storage.v2.RewriteObjectRequest;
import com.google.storage.v2.RewriteResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.StorageSettings;
import com.google.storage.v2.UpdateBucketRequest;
import com.google.storage.v2.UpdateObjectRequest;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.StorageStub;
import com.google.storage.v2.stub.StorageStubSettings;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StorageClient
implements BackgroundResource {
    private final StorageSettings settings;
    private final StorageStub stub;

    public static final StorageClient create() throws IOException {
        return StorageClient.create(StorageSettings.newBuilder().build());
    }

    public static final StorageClient create(StorageSettings settings) throws IOException {
        return new StorageClient(settings);
    }

    public static final StorageClient create(StorageStub stub) {
        return new StorageClient(stub);
    }

    protected StorageClient(StorageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StorageStubSettings)settings.getStubSettings()).createStub();
    }

    protected StorageClient(StorageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StorageSettings getSettings() {
        return this.settings;
    }

    public StorageStub getStub() {
        return this.stub;
    }

    public final void deleteBucket(BucketName name) {
        DeleteBucketRequest request = DeleteBucketRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteBucket(request);
    }

    public final void deleteBucket(String name) {
        DeleteBucketRequest request = DeleteBucketRequest.newBuilder().setName(name).build();
        this.deleteBucket(request);
    }

    public final void deleteBucket(DeleteBucketRequest request) {
        this.deleteBucketCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<DeleteBucketRequest, Empty> deleteBucketCallable() {
        return this.stub.deleteBucketCallable();
    }

    public final Bucket getBucket(BucketName name) {
        GetBucketRequest request = GetBucketRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBucket(request);
    }

    public final Bucket getBucket(String name) {
        GetBucketRequest request = GetBucketRequest.newBuilder().setName(name).build();
        return this.getBucket(request);
    }

    public final Bucket getBucket(GetBucketRequest request) {
        return (Bucket)this.getBucketCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<GetBucketRequest, Bucket> getBucketCallable() {
        return this.stub.getBucketCallable();
    }

    public final Bucket createBucket(ProjectName parent, Bucket bucket, String bucketId) {
        CreateBucketRequest request = CreateBucketRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBucket(bucket).setBucketId(bucketId).build();
        return this.createBucket(request);
    }

    public final Bucket createBucket(String parent, Bucket bucket, String bucketId) {
        CreateBucketRequest request = CreateBucketRequest.newBuilder().setParent(parent).setBucket(bucket).setBucketId(bucketId).build();
        return this.createBucket(request);
    }

    public final Bucket createBucket(CreateBucketRequest request) {
        return (Bucket)this.createBucketCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<CreateBucketRequest, Bucket> createBucketCallable() {
        return this.stub.createBucketCallable();
    }

    public final ListBucketsPagedResponse listBuckets(ProjectName parent) {
        ListBucketsRequest request = ListBucketsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBuckets(request);
    }

    public final ListBucketsPagedResponse listBuckets(String parent) {
        ListBucketsRequest request = ListBucketsRequest.newBuilder().setParent(parent).build();
        return this.listBuckets(request);
    }

    public final ListBucketsPagedResponse listBuckets(ListBucketsRequest request) {
        return (ListBucketsPagedResponse)((java.lang.Object)this.listBucketsPagedCallable().call((java.lang.Object)request));
    }

    public final UnaryCallable<ListBucketsRequest, ListBucketsPagedResponse> listBucketsPagedCallable() {
        return this.stub.listBucketsPagedCallable();
    }

    public final UnaryCallable<ListBucketsRequest, ListBucketsResponse> listBucketsCallable() {
        return this.stub.listBucketsCallable();
    }

    public final Bucket lockBucketRetentionPolicy(BucketName bucket) {
        LockBucketRetentionPolicyRequest request = LockBucketRetentionPolicyRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).build();
        return this.lockBucketRetentionPolicy(request);
    }

    public final Bucket lockBucketRetentionPolicy(String bucket) {
        LockBucketRetentionPolicyRequest request = LockBucketRetentionPolicyRequest.newBuilder().setBucket(bucket).build();
        return this.lockBucketRetentionPolicy(request);
    }

    public final Bucket lockBucketRetentionPolicy(LockBucketRetentionPolicyRequest request) {
        return (Bucket)this.lockBucketRetentionPolicyCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<LockBucketRetentionPolicyRequest, Bucket> lockBucketRetentionPolicyCallable() {
        return this.stub.lockBucketRetentionPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final Bucket updateBucket(Bucket bucket, FieldMask updateMask) {
        UpdateBucketRequest request = UpdateBucketRequest.newBuilder().setBucket(bucket).setUpdateMask(updateMask).build();
        return this.updateBucket(request);
    }

    public final Bucket updateBucket(UpdateBucketRequest request) {
        return (Bucket)this.updateBucketCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<UpdateBucketRequest, Bucket> updateBucketCallable() {
        return this.stub.updateBucketCallable();
    }

    public final Object composeObject(ComposeObjectRequest request) {
        return (Object)this.composeObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<ComposeObjectRequest, Object> composeObjectCallable() {
        return this.stub.composeObjectCallable();
    }

    public final void deleteObject(BucketName bucket, String object) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).build();
        this.deleteObject(request);
    }

    public final void deleteObject(String bucket, String object) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket).setObject(object).build();
        this.deleteObject(request);
    }

    public final void deleteObject(BucketName bucket, String object, long generation) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        this.deleteObject(request);
    }

    public final void deleteObject(String bucket, String object, long generation) {
        DeleteObjectRequest request = DeleteObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        this.deleteObject(request);
    }

    public final void deleteObject(DeleteObjectRequest request) {
        this.deleteObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<DeleteObjectRequest, Empty> deleteObjectCallable() {
        return this.stub.deleteObjectCallable();
    }

    public final Object restoreObject(BucketName bucket, String object, long generation) {
        RestoreObjectRequest request = RestoreObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        return this.restoreObject(request);
    }

    public final Object restoreObject(String bucket, String object, long generation) {
        RestoreObjectRequest request = RestoreObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        return this.restoreObject(request);
    }

    public final Object restoreObject(RestoreObjectRequest request) {
        return (Object)this.restoreObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<RestoreObjectRequest, Object> restoreObjectCallable() {
        return this.stub.restoreObjectCallable();
    }

    public final CancelResumableWriteResponse cancelResumableWrite(String uploadId) {
        CancelResumableWriteRequest request = CancelResumableWriteRequest.newBuilder().setUploadId(uploadId).build();
        return this.cancelResumableWrite(request);
    }

    public final CancelResumableWriteResponse cancelResumableWrite(CancelResumableWriteRequest request) {
        return (CancelResumableWriteResponse)this.cancelResumableWriteCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<CancelResumableWriteRequest, CancelResumableWriteResponse> cancelResumableWriteCallable() {
        return this.stub.cancelResumableWriteCallable();
    }

    public final Object getObject(BucketName bucket, String object) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).build();
        return this.getObject(request);
    }

    public final Object getObject(String bucket, String object) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket).setObject(object).build();
        return this.getObject(request);
    }

    public final Object getObject(BucketName bucket, String object, long generation) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setObject(object).setGeneration(generation).build();
        return this.getObject(request);
    }

    public final Object getObject(String bucket, String object, long generation) {
        GetObjectRequest request = GetObjectRequest.newBuilder().setBucket(bucket).setObject(object).setGeneration(generation).build();
        return this.getObject(request);
    }

    public final Object getObject(GetObjectRequest request) {
        return (Object)this.getObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<GetObjectRequest, Object> getObjectCallable() {
        return this.stub.getObjectCallable();
    }

    public final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
        return this.stub.readObjectCallable();
    }

    public final BidiStreamingCallable<BidiReadObjectRequest, BidiReadObjectResponse> bidiReadObjectCallable() {
        return this.stub.bidiReadObjectCallable();
    }

    public final Object updateObject(Object object, FieldMask updateMask) {
        UpdateObjectRequest request = UpdateObjectRequest.newBuilder().setObject(object).setUpdateMask(updateMask).build();
        return this.updateObject(request);
    }

    public final Object updateObject(UpdateObjectRequest request) {
        return (Object)this.updateObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<UpdateObjectRequest, Object> updateObjectCallable() {
        return this.stub.updateObjectCallable();
    }

    public final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable() {
        return this.stub.writeObjectCallable();
    }

    public final BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> bidiWriteObjectCallable() {
        return this.stub.bidiWriteObjectCallable();
    }

    public final ListObjectsPagedResponse listObjects(BucketName parent) {
        ListObjectsRequest request = ListObjectsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listObjects(request);
    }

    public final ListObjectsPagedResponse listObjects(String parent) {
        ListObjectsRequest request = ListObjectsRequest.newBuilder().setParent(parent).build();
        return this.listObjects(request);
    }

    public final ListObjectsPagedResponse listObjects(ListObjectsRequest request) {
        return (ListObjectsPagedResponse)((java.lang.Object)this.listObjectsPagedCallable().call((java.lang.Object)request));
    }

    public final UnaryCallable<ListObjectsRequest, ListObjectsPagedResponse> listObjectsPagedCallable() {
        return this.stub.listObjectsPagedCallable();
    }

    public final UnaryCallable<ListObjectsRequest, ListObjectsResponse> listObjectsCallable() {
        return this.stub.listObjectsCallable();
    }

    public final RewriteResponse rewriteObject(RewriteObjectRequest request) {
        return (RewriteResponse)this.rewriteObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<RewriteObjectRequest, RewriteResponse> rewriteObjectCallable() {
        return this.stub.rewriteObjectCallable();
    }

    public final StartResumableWriteResponse startResumableWrite(StartResumableWriteRequest request) {
        return (StartResumableWriteResponse)this.startResumableWriteCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable() {
        return this.stub.startResumableWriteCallable();
    }

    public final QueryWriteStatusResponse queryWriteStatus(String uploadId) {
        QueryWriteStatusRequest request = QueryWriteStatusRequest.newBuilder().setUploadId(uploadId).build();
        return this.queryWriteStatus(request);
    }

    public final QueryWriteStatusResponse queryWriteStatus(QueryWriteStatusRequest request) {
        return (QueryWriteStatusResponse)this.queryWriteStatusCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable() {
        return this.stub.queryWriteStatusCallable();
    }

    public final Object moveObject(BucketName bucket, String sourceObject, String destinationObject) {
        MoveObjectRequest request = MoveObjectRequest.newBuilder().setBucket(bucket == null ? null : bucket.toString()).setSourceObject(sourceObject).setDestinationObject(destinationObject).build();
        return this.moveObject(request);
    }

    public final Object moveObject(String bucket, String sourceObject, String destinationObject) {
        MoveObjectRequest request = MoveObjectRequest.newBuilder().setBucket(bucket).setSourceObject(sourceObject).setDestinationObject(destinationObject).build();
        return this.moveObject(request);
    }

    public final Object moveObject(MoveObjectRequest request) {
        return (Object)this.moveObjectCallable().call((java.lang.Object)request);
    }

    public final UnaryCallable<MoveObjectRequest, Object> moveObjectCallable() {
        return this.stub.moveObjectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBucketsPagedResponse
    extends AbstractPagedListResponse<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage, ListBucketsFixedSizeCollection> {
        public static ApiFuture<ListBucketsPagedResponse> createAsync(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ApiFuture<ListBucketsResponse> futureResponse) {
            ApiFuture<ListBucketsPage> futurePage = ListBucketsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBucketsPagedResponse((ListBucketsPage)((java.lang.Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBucketsPagedResponse(ListBucketsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBucketsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListObjectsPagedResponse
    extends AbstractPagedListResponse<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage, ListObjectsFixedSizeCollection> {
        public static ApiFuture<ListObjectsPagedResponse> createAsync(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ApiFuture<ListObjectsResponse> futureResponse) {
            ApiFuture<ListObjectsPage> futurePage = ListObjectsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListObjectsPagedResponse((ListObjectsPage)((java.lang.Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListObjectsPagedResponse(ListObjectsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListObjectsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListObjectsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage, ListObjectsFixedSizeCollection> {
        private ListObjectsFixedSizeCollection(List<ListObjectsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListObjectsFixedSizeCollection createEmptyCollection() {
            return new ListObjectsFixedSizeCollection(null, 0);
        }

        protected ListObjectsFixedSizeCollection createCollection(List<ListObjectsPage> pages, int collectionSize) {
            return new ListObjectsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListObjectsPage
    extends AbstractPage<ListObjectsRequest, ListObjectsResponse, Object, ListObjectsPage> {
        private ListObjectsPage(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ListObjectsResponse response) {
            super(context, (java.lang.Object)response);
        }

        private static ListObjectsPage createEmptyPage() {
            return new ListObjectsPage(null, null);
        }

        protected ListObjectsPage createPage(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ListObjectsResponse response) {
            return new ListObjectsPage(context, response);
        }

        public ApiFuture<ListObjectsPage> createPageAsync(PageContext<ListObjectsRequest, ListObjectsResponse, Object> context, ApiFuture<ListObjectsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBucketsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage, ListBucketsFixedSizeCollection> {
        private ListBucketsFixedSizeCollection(List<ListBucketsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBucketsFixedSizeCollection createEmptyCollection() {
            return new ListBucketsFixedSizeCollection(null, 0);
        }

        protected ListBucketsFixedSizeCollection createCollection(List<ListBucketsPage> pages, int collectionSize) {
            return new ListBucketsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBucketsPage
    extends AbstractPage<ListBucketsRequest, ListBucketsResponse, Bucket, ListBucketsPage> {
        private ListBucketsPage(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ListBucketsResponse response) {
            super(context, (java.lang.Object)response);
        }

        private static ListBucketsPage createEmptyPage() {
            return new ListBucketsPage(null, null);
        }

        protected ListBucketsPage createPage(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ListBucketsResponse response) {
            return new ListBucketsPage(context, response);
        }

        public ApiFuture<ListBucketsPage> createPageAsync(PageContext<ListBucketsRequest, ListBucketsResponse, Bucket> context, ApiFuture<ListBucketsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

