/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.identity;

import jakarta.annotation.Nonnull;
import java.util.Arrays;

public enum ServiceIdentityType {
    NULL_TYPE(0),
    AWS_IAM(1);

    private static final ServiceIdentityType[] REVERSE_MAPPING_ARRAY;
    private final int code;

    private ServiceIdentityType(int code) {
        this.code = code;
    }

    @Nonnull
    public static ServiceIdentityType fromCode(int identityTypeCode) {
        if (identityTypeCode < 0 || identityTypeCode >= REVERSE_MAPPING_ARRAY.length) {
            return NULL_TYPE;
        }
        return REVERSE_MAPPING_ARRAY[identityTypeCode];
    }

    public int getCode() {
        return this.code;
    }

    static {
        int maxCode = Arrays.stream(ServiceIdentityType.values()).mapToInt(ServiceIdentityType::getCode).max().orElse(0);
        REVERSE_MAPPING_ARRAY = new ServiceIdentityType[maxCode + 1];
        ServiceIdentityType[] serviceIdentityTypeArray = ServiceIdentityType.values();
        int n = serviceIdentityTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ServiceIdentityType authType;
            ServiceIdentityType.REVERSE_MAPPING_ARRAY[authType.code] = authType = serviceIdentityTypeArray[i];
        }
    }
}

