/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.async;

import io.smallrye.faulttolerance.core.FaultToleranceContext;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Future;
import io.smallrye.faulttolerance.core.util.Preconditions;

public class SyncAsyncSplit<V>
implements FaultToleranceStrategy<V> {
    private final FaultToleranceStrategy<V> asyncDelegate;
    private final FaultToleranceStrategy<V> syncDelegate;

    public SyncAsyncSplit(FaultToleranceStrategy<V> asyncDelegate, FaultToleranceStrategy<V> syncDelegate) {
        this.asyncDelegate = Preconditions.checkNotNull(asyncDelegate, "Async delegate must be set");
        this.syncDelegate = Preconditions.checkNotNull(syncDelegate, "Sync delegate must be set");
    }

    @Override
    public Future<V> apply(FaultToleranceContext<V> ctx) {
        if (ctx.isAsync()) {
            return this.asyncDelegate.apply(ctx);
        }
        return this.syncDelegate.apply(ctx);
    }
}

