/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.core.invocation.Invoker;
import jakarta.interceptor.InvocationContext;
import java.util.function.Function;

public class InterceptionInvoker<V>
implements Invoker<V> {
    private final InvocationContext invocationContext;

    public InterceptionInvoker(InvocationContext invocationContext) {
        this.invocationContext = invocationContext;
    }

    public int parametersCount() {
        return this.invocationContext.getParameters().length;
    }

    public <T> T getArgument(int index, Class<T> parameterType) {
        return parameterType.cast(this.invocationContext.getParameters()[index]);
    }

    public <T> T replaceArgument(int index, Class<T> parameterType, Function<T, T> transformation) {
        Object[] arguments = this.invocationContext.getParameters();
        T oldArg = parameterType.cast(arguments[index]);
        T newArg = transformation.apply(oldArg);
        arguments[index] = newArg;
        this.invocationContext.setParameters(arguments);
        return oldArg;
    }

    public V proceed() throws Exception {
        return (V)this.invocationContext.proceed();
    }
}

