/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.common;

import jakarta.ws.rs.core.SecurityContext;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.Principal;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.polaris.core.auth.PolarisPrincipal;

public interface CatalogAdapter {
    default public Namespace decodeNamespace(String namespace) {
        return RESTUtil.decodeNamespace((String)URLEncoder.encode(namespace, Charset.defaultCharset()));
    }

    default public PolarisPrincipal validatePrincipal(SecurityContext securityContext) {
        Principal authenticatedPrincipal = securityContext.getUserPrincipal();
        if (authenticatedPrincipal instanceof PolarisPrincipal) {
            PolarisPrincipal polarisPrincipal = (PolarisPrincipal)authenticatedPrincipal;
            return polarisPrincipal;
        }
        throw new NotAuthorizedException("Failed to find authenticatedPrincipal in SecurityContext", new Object[0]);
    }
}

