/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.executor;

public enum TriggerEvent {
    BEFORE_INSERT(0, "before insert"),
    AFTER_INSERT(1, "after insert");

    private final byte id;
    private final String event;

    private TriggerEvent(byte id, String event) {
        this.id = id;
        this.event = event;
    }

    public byte getId() {
        return this.id;
    }

    public String toString() {
        return this.event;
    }

    public static TriggerEvent construct(byte id) {
        switch (id) {
            case 0: {
                return BEFORE_INSERT;
            }
            case 1: {
                return AFTER_INSERT;
            }
        }
        throw new IllegalArgumentException(String.format("No such trigger event (id: %d)", id));
    }
}

