/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.tracing.TracingManager;
import org.apache.iotdb.db.query.reader.universal.Element;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class PriorityMergeReader
implements IPointReader {
    protected long currentReadStopTime;
    protected PriorityQueue<Element> heap;

    public PriorityMergeReader() {
        this.heap = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timeValuePair.getTimestamp(), o2.timeValuePair.getTimestamp());
            return timeCompare != 0 ? timeCompare : o2.priority.compareTo(o1.priority);
        });
    }

    public PriorityMergeReader(List<IPointReader> prioritySeriesReaders, int startPriority) throws IOException {
        this.heap = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timeValuePair.getTimestamp(), o2.timeValuePair.getTimestamp());
            return timeCompare != 0 ? timeCompare : o2.priority.compareTo(o1.priority);
        });
        for (IPointReader reader : prioritySeriesReaders) {
            this.addReader(reader, startPriority++);
        }
    }

    public void addReader(IPointReader reader, long priority) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            this.heap.add(new Element(reader, reader.nextTimeValuePair(), new MergeReaderPriority(priority, 0L)));
        } else {
            reader.close();
        }
    }

    public void addReader(IPointReader reader, MergeReaderPriority priority, long endTime, QueryContext context) throws IOException {
        if (reader.hasNextTimeValuePair()) {
            this.heap.add(new Element(reader, reader.nextTimeValuePair(), priority));
            this.currentReadStopTime = Math.max(this.currentReadStopTime, endTime);
            if (context.isEnableTracing()) {
                this.addOverlappedPageNum(context.getQueryId());
            }
        } else {
            reader.close();
        }
    }

    private void addOverlappedPageNum(long queryId) {
        TracingManager.getInstance().addOverlappedPageNum(queryId);
    }

    public long getCurrentReadStopTime() {
        return this.currentReadStopTime;
    }

    public boolean hasNextTimeValuePair() {
        return !this.heap.isEmpty();
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        Element top = this.heap.poll();
        TimeValuePair ret = top.getTimeValuePair();
        TimeValuePair topNext = null;
        if (top.hasNext()) {
            top.next();
            topNext = top.currPair();
        }
        this.updateHeap(ret, topNext);
        if (topNext != null) {
            top.timeValuePair = topNext;
            this.heap.add(top);
        }
        return ret;
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        return this.heap.peek().getTimeValuePair();
    }

    protected void updateHeap(TimeValuePair ret, TimeValuePair topNext) throws IOException {
        long topNextTime;
        long topTime = ret.getTimestamp();
        long l = topNextTime = topNext == null ? Long.MAX_VALUE : topNext.getTimestamp();
        while (!this.heap.isEmpty() && this.heap.peek().currTime() == topTime) {
            Element e = this.heap.poll();
            this.fillNullValue(ret, e.getTimeValuePair());
            if (!e.hasNext()) {
                e.reader.close();
                continue;
            }
            e.next();
            if (e.currTime() == topNextTime) {
                this.fillNullValue(topNext, e.getTimeValuePair());
                if (e.hasNext()) {
                    e.next();
                    this.heap.add(e);
                    continue;
                }
                e.close();
                continue;
            }
            this.heap.add(e);
        }
    }

    protected void fillNullValue(TimeValuePair v, TimeValuePair c) {
    }

    public void close() throws IOException {
        while (!this.heap.isEmpty()) {
            Element e = this.heap.poll();
            e.close();
        }
    }

    public static class MergeReaderPriority
    implements Comparable<MergeReaderPriority> {
        long version;
        long offset;

        public MergeReaderPriority(long version, long offset) {
            this.version = version;
            this.offset = offset;
        }

        @Override
        public int compareTo(MergeReaderPriority o) {
            if (this.version < o.version) {
                return -1;
            }
            return this.version > o.version ? 1 : Long.compare(this.offset, o.offset);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MergeReaderPriority that = (MergeReaderPriority)object;
            return this.version == that.version && this.offset == that.offset;
        }

        public int hashCode() {
            return Objects.hash(this.version, this.offset);
        }
    }
}

