/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.traverser.collector;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mtree.traverser.collector.CollectorTraverser;
import org.apache.iotdb.db.metadata.path.PartialPath;

public abstract class MNodeCollector<T>
extends CollectorTraverser<T> {
    protected MManager.StorageGroupFilter storageGroupFilter = null;
    protected int targetLevel = -1;

    public MNodeCollector(IMNode startNode, PartialPath path) throws MetadataException {
        super(startNode, path);
    }

    @Override
    protected void traverse(IMNode node, int idx, int level) throws MetadataException {
        if (this.storageGroupFilter != null && node.isStorageGroup() && !this.storageGroupFilter.satisfy(node.getFullPath())) {
            return;
        }
        super.traverse(node, idx, level);
    }

    @Override
    protected boolean processInternalMatchedMNode(IMNode node, int idx, int level) {
        return false;
    }

    @Override
    protected boolean processFullMatchedMNode(IMNode node, int idx, int level) {
        if (this.targetLevel >= 0) {
            if (level < this.targetLevel) {
                return false;
            }
            while (level > this.targetLevel) {
                node = node.getParent();
                --level;
            }
            this.processResult(node);
            return true;
        }
        this.processResult(node);
        return false;
    }

    private void processResult(IMNode node) {
        if (this.hasLimit) {
            ++this.curOffset;
            if (this.curOffset < this.offset) {
                return;
            }
            ++this.count;
        }
        this.transferToResult(node);
    }

    protected abstract void transferToResult(IMNode var1);

    public void setStorageGroupFilter(MManager.StorageGroupFilter storageGroupFilter) {
        this.storageGroupFilter = storageGroupFilter;
    }

    public void setTargetLevel(int targetLevel) {
        this.targetLevel = targetLevel;
    }
}

