/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.query.reader.DataSourceInfo;
import org.apache.iotdb.cluster.server.handlers.caller.GenericHandler;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteSeriesReaderByTimestamp
implements IReaderByTimestamp {
    private static final Logger logger = LoggerFactory.getLogger(RemoteSeriesReaderByTimestamp.class);
    private DataSourceInfo sourceInfo;
    private AtomicReference<ByteBuffer> fetchResult = new AtomicReference();
    private GenericHandler<ByteBuffer> handler;

    public RemoteSeriesReaderByTimestamp(DataSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        this.handler = new GenericHandler<ByteBuffer>(sourceInfo.getCurrentNode(), this.fetchResult);
    }

    public Object[] getValuesInTimestamps(long[] timestamps, int length) throws IOException {
        if (!this.sourceInfo.checkCurClient()) {
            return null;
        }
        ByteBuffer result = ClusterDescriptor.getInstance().getConfig().isUseAsyncServer() ? this.fetchResultAsync(timestamps, length) : this.fetchResultSync(timestamps, length);
        return SerializeUtils.deserializeObjects((ByteBuffer)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer fetchResultAsync(long[] timestamps, int length) throws IOException {
        ArrayList<Long> timestampList = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            timestampList.add(timestamps[i]);
        }
        AtomicReference<ByteBuffer> atomicReference = this.fetchResult;
        synchronized (atomicReference) {
            this.fetchResult.set(null);
            try {
                this.sourceInfo.getCurAsyncClient(ClusterConstant.getReadOperationTimeoutMS()).fetchSingleSeriesByTimestamps(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId(), timestampList, this.handler);
                this.fetchResult.wait(ClusterConstant.getReadOperationTimeoutMS());
            }
            catch (TException e) {
                if (!this.sourceInfo.switchNode(true, timestamps[0])) {
                    return null;
                }
                return this.fetchResultAsync(timestamps, length);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Query {} interrupted", (Object)this.sourceInfo);
                return null;
            }
        }
        return this.fetchResult.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer fetchResultSync(long[] timestamps, int length) throws IOException {
        SyncDataClient curSyncClient = null;
        ArrayList<Long> timestampList = new ArrayList<Long>(length);
        for (int i = 0; i < length; ++i) {
            timestampList.add(timestamps[i]);
        }
        try {
            curSyncClient = this.sourceInfo.getCurSyncClient(ClusterConstant.getReadOperationTimeoutMS());
            ByteBuffer i = curSyncClient.fetchSingleSeriesByTimestamps(this.sourceInfo.getHeader(), this.sourceInfo.getReaderId(), timestampList);
            return i;
        }
        catch (TException e) {
            curSyncClient.close();
            if (!this.sourceInfo.switchNode(true, timestamps[0])) {
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = this.fetchResultSync(timestamps, length);
            return byteBuffer;
        }
        finally {
            if (curSyncClient != null) {
                curSyncClient.returnSelf();
            }
        }
    }
}

