/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNodesListHandler
implements AsyncMethodCallback<List<String>> {
    private static final Logger logger = LoggerFactory.getLogger(GetNodesListHandler.class);
    private Node contact;
    private AtomicReference<List<String>> result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(List<String> resp) {
        logger.info("Received node lists of size {} from {}", (Object)resp.size(), (Object)this.contact);
        AtomicReference<List<String>> atomicReference = this.result;
        synchronized (atomicReference) {
            this.result.set(resp);
            this.result.notifyAll();
        }
    }

    public void onError(Exception exception) {
        logger.warn("Cannot get node list from {}, because", (Object)this.contact, (Object)exception);
    }

    public void setResponse(AtomicReference<List<String>> response) {
        this.result = response;
    }

    public void setContact(Node contact) {
        this.contact = contact;
    }
}

