/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.TriggerManagementException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class DropTriggerPlan
extends PhysicalPlan {
    private String triggerName;
    private PartialPath authPath;

    public DropTriggerPlan() {
        super(Operator.OperatorType.DROP_TRIGGER);
        this.canBeSplit = false;
    }

    public DropTriggerPlan(String triggerName) {
        super(Operator.OperatorType.DROP_TRIGGER);
        this.triggerName = triggerName;
        this.canBeSplit = false;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.DROP_TRIGGER.ordinal());
        this.putString(stream, this.triggerName);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.DROP_TRIGGER.ordinal());
        this.putString(buffer, this.triggerName);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.triggerName = this.readString(buffer);
    }

    @Override
    public boolean isAuthenticationRequired() {
        if (this.authPath == null) {
            try {
                this.authPath = TriggerRegistrationService.getInstance().getRegistrationInformation(this.triggerName).getFullPath();
            }
            catch (TriggerManagementException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<? extends PartialPath> getAuthPaths() {
        return this.isAuthenticationRequired() ? Collections.singletonList(this.authPath) : Collections.emptyList();
    }
}

