/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.thrift.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateMachineProcedure<Env, TState>
extends Procedure<Env> {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineProcedure.class);
    private static final int EOF_STATE = Integer.MIN_VALUE;
    private Flow stateFlow = Flow.HAS_MORE_STATE;
    private final ConcurrentLinkedDeque<Integer> states = new ConcurrentLinkedDeque();
    private final List<Procedure<?>> subProcList = new ArrayList();
    private int cycles = 0;
    private static final int NO_NEXT_STATE = -1;
    private int nextState = -1;
    protected boolean isGeneratedByPipe;
    private boolean isStateDeserialized = false;

    protected StateMachineProcedure() {
        this(false);
    }

    protected StateMachineProcedure(boolean isGeneratedByPipe) {
        this.isGeneratedByPipe = isGeneratedByPipe;
    }

    protected final int getCycles() {
        return this.cycles;
    }

    protected abstract Flow executeFromState(Env var1, TState var2) throws InterruptedException;

    protected abstract void rollbackState(Env var1, TState var2) throws IOException, InterruptedException, ProcedureException;

    protected abstract TState getState(int var1);

    protected abstract int getStateId(TState var1);

    protected abstract TState getInitialState();

    protected void setNextState(TState state) {
        this.setNextState(this.getStateId(state));
    }

    protected void addChildProcedure(Procedure<Env> childProcedure) {
        this.subProcList.add(childProcedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure<Env>[] execute(Env env) throws InterruptedException {
        this.updateTimestamp();
        try {
            Procedure[] procedureArray;
            if (this.noMoreState() || this.isFailed()) {
                Procedure<Env>[] procedureArray2 = null;
                return procedureArray2;
            }
            TState state = this.getCurrentState();
            if (this.states.isEmpty()) {
                this.setNextState(this.getStateId(state));
                this.addNextStateAndCalculateCycles();
            }
            LOG.trace("{}", (Object)this);
            this.stateFlow = this.executeFromState(env, state);
            if (!this.isFailed()) {
                this.addNextStateAndCalculateCycles();
            }
            this.setStateDeserialized(false);
            if (!this.subProcList.isEmpty()) {
                Procedure[] subProcedures = this.subProcList.toArray(new Procedure[0]);
                this.subProcList.clear();
                Procedure[] procedureArray3 = subProcedures;
                return procedureArray3;
            }
            if (this.isWaiting() || this.isFailed() || this.noMoreState()) {
                procedureArray = null;
            } else {
                Procedure[] procedureArray4 = new Procedure[1];
                procedureArray = procedureArray4;
                procedureArray4[0] = this;
            }
            Procedure[] procedureArray5 = procedureArray;
            return procedureArray5;
        }
        finally {
            this.updateTimestamp();
        }
    }

    private void addNextStateAndCalculateCycles() {
        int stateToBeAdded = Integer.MIN_VALUE;
        if (Flow.HAS_MORE_STATE == this.stateFlow) {
            if (this.nextState == -1) {
                LOG.error("StateMachineProcedure pid={} not set next state, but return HAS_MORE_STATE. It is likely that there is some problem with the code. Please check the code. This procedure is about to be terminated: {}", (Object)this.getProcId(), (Object)this);
                this.stateFlow = Flow.NO_MORE_STATE;
            } else {
                stateToBeAdded = this.nextState;
            }
        }
        if (Flow.NO_MORE_STATE == this.stateFlow && this.nextState != -1) {
            LOG.warn("StateMachineProcedure pid={} set next state to {}, but return NO_MORE_STATE", (Object)this.getProcId(), (Object)this.nextState);
        }
        this.cycles = this.getStateId(this.getCurrentState()) == stateToBeAdded ? ++this.cycles : 0;
        this.states.add(stateToBeAdded);
        this.nextState = -1;
    }

    @Override
    protected void rollback(Env env) throws IOException, InterruptedException, ProcedureException {
        if (this.isEofState()) {
            this.states.removeLast();
        }
        try {
            this.updateTimestamp();
            this.rollbackState(env, this.getCurrentState());
        }
        finally {
            this.states.removeLast();
            this.updateTimestamp();
        }
    }

    protected boolean isEofState() {
        return !this.states.isEmpty() && this.states.getLast() == Integer.MIN_VALUE;
    }

    protected boolean isRollbackSupported(TState state) {
        return false;
    }

    private boolean noMoreState() {
        return this.stateFlow == Flow.NO_MORE_STATE;
    }

    @Nullable
    protected TState getCurrentState() {
        if (!this.states.isEmpty()) {
            if (this.states.getLast() == Integer.MIN_VALUE) {
                return null;
            }
            return this.getState(this.states.getLast());
        }
        return this.getInitialState();
    }

    private void setNextState(int stateId) {
        this.nextState = stateId;
    }

    @Override
    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        if (!this.isFinished() && !this.isEofState() && this.getCurrentState() != null) {
            builder.append(":").append(this.getCurrentState());
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ArrayList<Integer> copyStates = new ArrayList<Integer>(this.states);
        stream.writeInt(copyStates.size());
        for (int state : copyStates) {
            stream.writeInt(state);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        int stateCount = byteBuffer.getInt();
        this.states.clear();
        if (stateCount > 0) {
            for (int i = 0; i < stateCount; ++i) {
                this.states.add(byteBuffer.getInt());
            }
            if (this.isEofState()) {
                this.stateFlow = Flow.NO_MORE_STATE;
            }
        }
        this.setStateDeserialized(true);
    }

    public boolean isStateDeserialized() {
        return this.isStateDeserialized;
    }

    private void setStateDeserialized(boolean isDeserialized) {
        this.isStateDeserialized = isDeserialized;
    }

    public static enum Flow {
        HAS_MORE_STATE,
        NO_MORE_STATE;

    }
}

