/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PlanFragmentId {
    private final QueryId queryId;
    private final int id;
    private int nextFragmentInstanceId;

    public static PlanFragmentId valueOf(String stageId) {
        List<String> ids = QueryId.parseDottedId(stageId, 2, "stageId");
        return PlanFragmentId.valueOf(ids);
    }

    public static PlanFragmentId valueOf(List<String> ids) {
        Preconditions.checkArgument((ids.size() == 2 ? 1 : 0) != 0, (String)"Expected two ids but got: %s", ids);
        return new PlanFragmentId(new QueryId(ids.get(0)), Integer.parseInt(ids.get(1)));
    }

    public PlanFragmentId(String queryId, int id) {
        this(new QueryId(queryId), id);
    }

    public PlanFragmentId(QueryId queryId, int id) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.id = id;
        this.nextFragmentInstanceId = 0;
    }

    public FragmentInstanceId genFragmentInstanceId() {
        return new FragmentInstanceId(this, String.valueOf(this.nextFragmentInstanceId++));
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return String.format("%s.%d", this.queryId, this.id);
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.queryId.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.id, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.queryId.serialize(stream);
        ReadWriteIOUtils.write((int)this.id, (OutputStream)stream);
    }

    public static PlanFragmentId deserialize(ByteBuffer byteBuffer) {
        return new PlanFragmentId(QueryId.deserialize(byteBuffer), ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanFragmentId that = (PlanFragmentId)o;
        return this.id == that.id && Objects.equals(this.queryId, that.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.id);
    }
}

