/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.last;

import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.AbstractUpdateLastCacheOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedUpdateLastCacheOperator
extends AbstractUpdateLastCacheOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(AlignedUpdateLastCacheOperator.class);
    private final AlignedPath seriesPath;
    private final PartialPath devicePath;

    public AlignedUpdateLastCacheOperator(OperatorContext operatorContext, Operator child, AlignedPath seriesPath, DataNodeSchemaCache dataNodeSchemaCache, boolean needUpdateCache, boolean needUpdateNullEntry) {
        super(operatorContext, child, dataNodeSchemaCache, needUpdateCache, needUpdateNullEntry);
        this.seriesPath = seriesPath;
        this.devicePath = seriesPath.getDevicePath();
    }

    @Override
    public TsBlock next() throws Exception {
        TsBlock res = this.child.nextWithTimer();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return LAST_QUERY_EMPTY_TSBLOCK;
        }
        if (res.getPositionCount() != 1) {
            throw new IllegalArgumentException("last read result should only have one record");
        }
        this.tsBlockBuilder.reset();
        int i = 0;
        while (i + 1 < res.getValueColumnCount()) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode((String)this.seriesPath.getMeasurementList().get(i / 2)), (IMeasurementSchema)this.seriesPath.getSchemaList().get(i / 2), Boolean.valueOf(true));
            if (!res.getColumn(i).isNull(0)) {
                long lastTime = res.getColumn(i).getLong(0);
                TsPrimitiveType lastValue = res.getColumn(i + 1).getTsPrimitiveType(0);
                this.mayUpdateLastCache(lastTime, lastValue, measurementPath);
                this.appendLastValueToTsBlockBuilder(lastTime, lastValue, measurementPath, ((IMeasurementSchema)this.seriesPath.getSchemaList().get(i / 2)).getType().name());
            } else if (this.needUpdateNullEntry) {
                this.mayUpdateLastCache(Long.MIN_VALUE, null, measurementPath);
            }
            i += 2;
        }
        return !this.tsBlockBuilder.isEmpty() ? this.tsBlockBuilder.build() : LAST_QUERY_EMPTY_TSBLOCK;
    }

    protected void appendLastValueToTsBlockBuilder(long lastTime, TsPrimitiveType lastValue, MeasurementPath measurementPath, String type) {
        LastQueryUtil.appendLastValue(this.tsBlockBuilder, lastTime, measurementPath.getFullPath(), lastValue.getStringValue(), type);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + RamUsageEstimator.sizeOf((String)this.databaseName) + MemoryEstimationHelper.getEstimatedSizeOfPartialPath(this.devicePath) + MemoryEstimationHelper.getEstimatedSizeOfPartialPath((PartialPath)this.seriesPath) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

