/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.statemachine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.read.ConfigPhysicalReadPlan;
import org.apache.iotdb.confignode.exception.physical.UnknownPhysicalPlanTypeException;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.consensus.ConsensusManager;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.persistence.executor.ConfigPlanExecutor;
import org.apache.iotdb.confignode.persistence.schema.ConfigNodeSnapshotParser;
import org.apache.iotdb.confignode.writelog.io.SingleFileLogReader;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.ByteBufferConsensusRequest;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.utils.writelog.LogWriter;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRegionStateMachine
implements IStateMachine,
IStateMachine.EventApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRegionStateMachine.class);
    private static final ExecutorService threadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.CONFIG_NODE_RECOVER.getName());
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final ConfigPlanExecutor executor;
    private ConfigManager configManager;
    private LogWriter simpleLogWriter;
    private File simpleLogFile;
    private int startIndex;
    private int endIndex;
    private static final String CURRENT_FILE_DIR = ConsensusManager.getConfigRegionDir() + File.separator + "current";
    private static final String PROGRESS_FILE_PATH = CURRENT_FILE_DIR + File.separator + "log_inprogress_";
    private static final String FILE_PATH = CURRENT_FILE_DIR + File.separator + "log_";
    private static final long LOG_FILE_MAX_SIZE = CONF.getConfigNodeSimpleConsensusLogSegmentSizeMax();
    private final TEndPoint currentNodeTEndPoint;
    private static Pattern LOG_INPROGRESS_PATTERN = Pattern.compile("\\d+");
    private static Pattern LOG_PATTERN = Pattern.compile("(?<=_)(\\d+)$");

    public ConfigRegionStateMachine(ConfigManager configManager, ConfigPlanExecutor executor) {
        this.executor = executor;
        this.configManager = configManager;
        this.currentNodeTEndPoint = new TEndPoint().setIp(ConfigNodeDescriptor.getInstance().getConf().getInternalAddress()).setPort(ConfigNodeDescriptor.getInstance().getConf().getConsensusPort());
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public TSStatus write(IConsensusRequest request) {
        return Optional.ofNullable(request).map(o -> this.write((ConfigPhysicalPlan)request)).orElseGet(() -> new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode()));
    }

    protected TSStatus write(ConfigPhysicalPlan plan) {
        TSStatus result;
        try {
            result = this.executor.executeNonQueryPlan(plan);
        }
        catch (UnknownPhysicalPlanTypeException e) {
            LOGGER.error("Execute non-query plan failed", (Throwable)e);
            result = new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
            this.writeLogForSimpleConsensus(plan);
        }
        if (result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            PipeConfigNodeAgent.runtime().listener().tryListenToPlan(plan, false);
        }
        return result;
    }

    public IConsensusRequest deserializeRequest(IConsensusRequest request) {
        ConfigPhysicalPlan result;
        if (request instanceof ByteBufferConsensusRequest) {
            try {
                result = ConfigPhysicalPlan.Factory.create(request.serializeToByteBuffer());
            }
            catch (Exception e) {
                LOGGER.error("Deserialization error for write plan, request: {}, bytebuffer: {}", new Object[]{request, request.serializeToByteBuffer(), e});
                return null;
            }
        } else if (request instanceof ConfigPhysicalPlan) {
            result = request;
        } else {
            LOGGER.error("Unexpected write plan, request: {}, bytebuffer: {}", (Object)request, (Object)request.serializeToByteBuffer());
            return null;
        }
        return result;
    }

    public DataSet read(IConsensusRequest request) {
        if (!(request instanceof ConfigPhysicalReadPlan)) {
            LOGGER.error("Unexpected read plan : {}", (Object)request);
            return null;
        }
        ConfigPhysicalReadPlan plan = (ConfigPhysicalReadPlan)request;
        return this.read(plan);
    }

    protected DataSet read(ConfigPhysicalReadPlan plan) {
        DataSet result;
        try {
            result = this.executor.executeQueryPlan(plan);
        }
        catch (AuthException | UnknownPhysicalPlanTypeException e) {
            LOGGER.error("Execute query plan failed", e);
            result = null;
        }
        return result;
    }

    public boolean takeSnapshot(File snapshotDir) {
        block3: {
            if (this.executor.takeSnapshot(snapshotDir)) {
                try {
                    PipeConfigNodeAgent.runtime().listener().tryListenToSnapshots(ConfigNodeSnapshotParser.getSnapshots());
                    return true;
                }
                catch (IOException e) {
                    if (!PipeConfigNodeAgent.runtime().listener().isOpened()) break block3;
                    LOGGER.warn("Config Region Listening Queue Listen to snapshot failed, the historical data may not be transferred.", (Throwable)e);
                }
            }
        }
        return false;
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        block2: {
            try {
                this.executor.loadSnapshot(latestSnapshotRootDir);
                PipeConfigNodeAgent.runtime().listener().tryListenToSnapshots(ConfigNodeSnapshotParser.getSnapshots());
            }
            catch (IOException e) {
                if (!PipeConfigNodeAgent.runtime().listener().isOpened()) break block2;
                LOGGER.warn("Config Region Listening Queue Listen to snapshot failed when startup, snapshot will be tried again when starting schema transferring pipes", (Throwable)e);
            }
        }
    }

    public void notifyLeaderChanged(ConsensusGroupId groupId, int newLeaderId) {
        int currentNodeId = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
        if (currentNodeId != newLeaderId) {
            LOGGER.info("Current node [nodeId:{}, ip:port: {}] is no longer the leader, the new leader is [nodeId:{}]", new Object[]{currentNodeId, this.currentNodeTEndPoint, newLeaderId});
        }
    }

    public void notifyNotLeader() {
        int currentNodeId = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId();
        LOGGER.info("Current node [nodeId:{}, ip:port: {}] is no longer the leader, start cleaning up related services", (Object)currentNodeId, (Object)this.currentNodeTEndPoint);
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().stopPipeMetaSync();
        this.configManager.getPipeManager().getPipeRuntimeCoordinator().stopPipeHeartbeat();
        this.configManager.getSubscriptionManager().getSubscriptionCoordinator().stopSubscriptionMetaSync();
        this.configManager.getLoadManager().stopLoadServices();
        this.configManager.getProcedureManager().stopExecutor();
        this.configManager.getRetryFailedTasksThread().stopRetryFailedTasksService();
        this.configManager.getPartitionManager().stopRegionCleaner();
        this.configManager.getCQManager().stopCQScheduler();
        this.configManager.getClusterSchemaManager().clearSchemaQuotaCache();
        this.configManager.removeMetrics();
        PipeConfigNodeAgent.runtime().notifyLeaderUnavailable();
        PipeConfigNodeAgent.receiver().cleanPipeReceiverDir();
        LOGGER.info("Current node [nodeId:{}, ip:port: {}] is no longer the leader, all services on old leader are unavailable now.", (Object)currentNodeId, (Object)this.currentNodeTEndPoint);
    }

    public void notifyLeaderReady() {
        LOGGER.info("Current node [nodeId: {}, ip:port: {}] becomes config region leader", (Object)ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId(), (Object)this.currentNodeTEndPoint);
        this.configManager.getLoadManager().startLoadServices();
        this.configManager.getProcedureManager().startExecutor();
        threadPool.submit(() -> this.configManager.getProcedureManager().getStore().getProcedureInfo().upgrade());
        this.configManager.getRetryFailedTasksThread().startRetryFailedTasksService();
        this.configManager.getPartitionManager().startRegionCleaner();
        this.configManager.addMetrics();
        PipeConfigNodeAgent.runtime().notifyLeaderReady();
        threadPool.submit(() -> this.configManager.getCQManager().startCQScheduler());
        threadPool.submit(() -> this.configManager.getPipeManager().getPipeRuntimeCoordinator().startPipeMetaSync());
        threadPool.submit(() -> this.configManager.getPipeManager().getPipeRuntimeCoordinator().startPipeHeartbeat());
        threadPool.submit(() -> this.configManager.getPipeManager().getPipeRuntimeCoordinator().onConfigRegionGroupLeaderChanged());
        threadPool.submit(() -> this.configManager.getSubscriptionManager().getSubscriptionCoordinator().startSubscriptionMetaSync());
        threadPool.submit(() -> this.configManager.getClusterManager().checkClusterId());
        LOGGER.info("Current node [nodeId: {}, ip:port: {}] as config region leader is ready to work", (Object)ConfigNodeDescriptor.getInstance().getConf().getConfigNodeId(), (Object)this.currentNodeTEndPoint);
    }

    public void start() {
        if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
            this.initStandAloneConfigNode();
        }
    }

    public void stop() {
        PipeConfigNodeAgent.runtime().notifyLeaderUnavailable();
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    private void writeLogForSimpleConsensus(ConfigPhysicalPlan plan) {
        if (this.simpleLogFile.length() > LOG_FILE_MAX_SIZE) {
            try {
                this.simpleLogWriter.force();
                File completedFilePath = new File(FILE_PATH + this.startIndex + "_" + this.endIndex);
                Files.move(this.simpleLogFile.toPath(), completedFilePath.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                LOGGER.error("Can't force logWriter for ConfigNode SimpleConsensus mode", (Throwable)e);
            }
            for (int retry = 0; retry < 5; ++retry) {
                try {
                    this.simpleLogWriter.close();
                    break;
                }
                catch (IOException e) {
                    LOGGER.warn("Can't close StandAloneLog for ConfigNode SimpleConsensus mode, filePath: {}, retry: {}", (Object)this.simpleLogFile.getAbsolutePath(), (Object)retry);
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        LOGGER.warn("Unexpected interruption during the close method of logWriter");
                    }
                    continue;
                }
            }
            this.startIndex = this.endIndex + 1;
            this.createLogFile(this.startIndex);
        }
        try {
            ByteBuffer buffer = plan.serializeToByteBuffer();
            buffer.position(buffer.limit());
            this.simpleLogWriter.write(buffer);
            ++this.endIndex;
        }
        catch (Exception e) {
            LOGGER.error("Can't serialize current ConfigPhysicalPlan for ConfigNode SimpleConsensus mode", (Throwable)e);
        }
    }

    private void initStandAloneConfigNode() {
        File dir = new File(CURRENT_FILE_DIR);
        dir.mkdirs();
        String[] list = new File(CURRENT_FILE_DIR).list();
        if (list != null && list.length != 0) {
            Arrays.sort(list, new FileComparator());
            for (String logFileName : list) {
                SingleFileLogReader logReader;
                File logFile = SystemFileFactory.INSTANCE.getFile(CURRENT_FILE_DIR + File.separator + logFileName);
                try {
                    logReader = new SingleFileLogReader(logFile);
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("InitStandAloneConfigNode meets error, can't find standalone log files, filePath: {}", (Object)logFile.getAbsolutePath(), (Object)e);
                    continue;
                }
                this.startIndex = this.endIndex;
                while (logReader.hasNext()) {
                    ++this.endIndex;
                    ConfigPhysicalPlan nextPlan = logReader.next();
                    try {
                        TSStatus status = this.executor.executeNonQueryPlan(nextPlan);
                        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        PipeConfigNodeAgent.runtime().listener().tryListenToPlan(nextPlan, false);
                    }
                    catch (UnknownPhysicalPlanTypeException e) {
                        LOGGER.error("Try listen to plan failed", (Throwable)e);
                    }
                }
                logReader.close();
            }
        } else {
            this.startIndex = 0;
            this.endIndex = 0;
        }
        ++this.startIndex;
        this.createLogFile(this.endIndex);
        ScheduledExecutorService simpleConsensusThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.CONFIG_NODE_SIMPLE_CONSENSUS_WAL_FLUSH.getName());
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)simpleConsensusThread, this::flushWALForSimpleConsensus, (long)0L, (long)CONF.getForceWalPeriodForConfigNodeSimpleInMs(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private void flushWALForSimpleConsensus() {
        if (this.simpleLogWriter != null) {
            try {
                this.simpleLogWriter.force();
            }
            catch (IOException e) {
                LOGGER.error("Can't force logWriter for ConfigNode flushWALForSimpleConsensus", (Throwable)e);
            }
        }
    }

    private void createLogFile(int startIndex) {
        this.simpleLogFile = SystemFileFactory.INSTANCE.getFile(PROGRESS_FILE_PATH + startIndex);
        try {
            if (!this.simpleLogFile.createNewFile()) {
                LOGGER.warn("ConfigNode SimpleConsensusFile has existed\uff0cfilePath:{}", (Object)this.simpleLogFile.getAbsolutePath());
            }
            this.simpleLogWriter = new LogWriter(this.simpleLogFile, false);
            LOGGER.info("Create ConfigNode SimpleConsensusFile: {}", (Object)this.simpleLogFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("Create ConfigNode SimpleConsensusFile failed, filePath: {}", (Object)this.simpleLogFile.getAbsolutePath(), (Object)e);
        }
    }

    static long parseEndIndex(String filename) {
        if (filename.startsWith("log_inprogress_")) {
            Matcher matcher = LOG_INPROGRESS_PATTERN.matcher(filename);
            if (matcher.find()) {
                return Long.parseLong(matcher.group());
            }
        } else {
            Matcher matcher = LOG_PATTERN.matcher(filename);
            if (matcher.find()) {
                return Long.parseLong(matcher.group());
            }
        }
        return 0L;
    }

    static class FileComparator
    implements Comparator<String> {
        FileComparator() {
        }

        @Override
        public int compare(String filename1, String filename2) {
            long id1 = ConfigRegionStateMachine.parseEndIndex(filename1);
            long id2 = ConfigRegionStateMachine.parseEndIndex(filename2);
            return Long.compare(id1, id2);
        }
    }
}

