/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.ArrayView;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.IntList;

public class PatternAggregationTracker {
    private static final int DEFAULT_CAPACITY = 10;
    private final Set<Integer> labels;
    private final boolean running;
    private int aggregated;
    private int evaluated;
    private final IntList allPositions;

    public PatternAggregationTracker(Set<Integer> labels, boolean running) {
        this.labels = Objects.requireNonNull(labels, "labels is null");
        this.running = running;
        this.allPositions = new IntList(10);
    }

    private PatternAggregationTracker(Set<Integer> labels, boolean running, int aggregated, int evaluated, IntList allPositions) {
        this.labels = labels;
        this.running = running;
        this.aggregated = aggregated;
        this.evaluated = evaluated;
        this.allPositions = allPositions;
    }

    public void reset() {
        this.aggregated = 0;
        this.evaluated = 0;
        this.allPositions.clear();
    }

    public ArrayView resolveNewPositions(int currentRow, ArrayView matchedLabels, int partitionStart, int patternStart) {
        Preconditions.checkArgument((currentRow >= patternStart && currentRow < patternStart + matchedLabels.length() ? 1 : 0) != 0, (Object)"current row is out of bounds of the match");
        Preconditions.checkState((this.aggregated <= this.evaluated && this.evaluated <= matchedLabels.length() ? 1 : 0) != 0, (Object)"PatternAggregationTracker in inconsistent state");
        IntList positions = new IntList(10);
        int last = this.running ? currentRow - patternStart : matchedLabels.length() - 1;
        for (int position = this.aggregated; position <= last; ++position) {
            if (this.appliesToLabel(matchedLabels.get(position))) {
                positions.add(position + patternStart - partitionStart);
                if (this.aggregated >= this.evaluated) {
                    this.allPositions.add(position);
                }
            }
            ++this.aggregated;
        }
        this.evaluated = this.aggregated;
        return positions.toArrayView();
    }

    public ArrayView getAllPositions(ArrayView labels) {
        Preconditions.checkState((this.evaluated <= labels.length() ? 1 : 0) != 0, (Object)"SetEvaluator in inconsistent state");
        for (int position = this.evaluated; position < labels.length(); ++position) {
            if (!this.appliesToLabel(labels.get(position))) continue;
            this.allPositions.add(position);
        }
        this.evaluated = labels.length();
        return this.allPositions.toArrayView();
    }

    private boolean appliesToLabel(int label) {
        return this.labels.isEmpty() || this.labels.contains(label);
    }

    public PatternAggregationTracker copy() {
        return new PatternAggregationTracker(this.labels, this.running, this.aggregated, this.evaluated, this.allPositions.copy());
    }

    public long getAllPositionsSizeInBytes() {
        return this.allPositions.getSizeInBytes();
    }
}

