/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.storageengine.dataregion.modification.DeletionPredicate;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;

public class TableDeletionEntry
extends ModEntry {
    private DeletionPredicate predicate;

    public TableDeletionEntry() {
        super(ModEntry.ModType.TABLE_DELETION);
    }

    public TableDeletionEntry(DeletionPredicate predicate, TimeRange timeRange) {
        this();
        this.predicate = predicate;
        this.timeRange = timeRange;
    }

    @Override
    public long serialize(OutputStream stream) throws IOException {
        long size = super.serialize(stream);
        return size += this.predicate.serialize(stream);
    }

    @Override
    public long serialize(ByteBuffer buffer) {
        long size = super.serialize(buffer);
        return size += this.predicate.serialize(buffer);
    }

    @Override
    public void deserialize(InputStream stream) throws IOException {
        super.deserialize(stream);
        this.predicate = new DeletionPredicate();
        this.predicate.deserialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        super.deserialize(buffer);
        this.predicate = new DeletionPredicate();
        this.predicate.deserialize(buffer);
    }

    @Override
    public boolean matches(PartialPath path) {
        IDeviceID iDeviceID = path.getIDeviceID();
        return this.predicate.matches(iDeviceID);
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + this.predicate.serializedSize();
    }

    @Override
    public boolean affects(IDeviceID deviceID, long startTime, long endTime) {
        return this.predicate.matches(deviceID) && ModificationUtils.overlap(this.getStartTime(), this.getEndTime(), startTime, endTime);
    }

    @Override
    public boolean affects(IDeviceID deviceID) {
        return this.predicate.matches(deviceID);
    }

    @Override
    public boolean affects(String measurementID) {
        return this.predicate.affects(measurementID);
    }

    @Override
    public boolean affectsAll(IDeviceID deviceID) {
        return this.predicate.matches(deviceID) && this.predicate.getMeasurementNames().isEmpty();
    }

    @Override
    public PartialPath keyOfPatternTree() {
        return new PartialPath(new String[]{this.predicate.getTableName(), "**"});
    }

    public String toString() {
        return "TableDeletionEntry{predicate=" + this.predicate + ", timeRange=" + this.timeRange + '}';
    }

    @Override
    public int compareTo(ModEntry o) {
        if (this.getType() != o.getType()) {
            return Byte.compare(this.getType().getTypeNum(), o.getType().getTypeNum());
        }
        return 0;
    }

    @Override
    public TableDeletionEntry clone() {
        TimeRange timeRangeCopy = new TimeRange(this.timeRange.getMin(), this.timeRange.getMax());
        return new TableDeletionEntry(this.predicate, timeRangeCopy);
    }

    public String getTableName() {
        return this.predicate.getTableName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDeletionEntry that = (TableDeletionEntry)o;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.timeRange, that.timeRange);
    }

    public int hashCode() {
        return Objects.hash(this.predicate, this.timeRange);
    }

    public DeletionPredicate getPredicate() {
        return this.predicate;
    }
}

