/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.store.mail.MessageMapper;

public class FetchGroupConverter {
    public static MessageMapper.FetchType getFetchType(FetchGroup group) {
        if (!group.getPartContentDescriptors().isEmpty()) {
            return MessageMapper.FetchType.FULL;
        }
        EnumSet profiles = group.profiles();
        if (profiles.size() == 1) {
            return FetchGroupConverter.toFetchType((FetchGroup.Profile)profiles.iterator().next());
        }
        Collection fetchTypes = (Collection)profiles.stream().map(FetchGroupConverter::toFetchType).collect(ImmutableList.toImmutableList());
        return FetchGroupConverter.reduce(fetchTypes);
    }

    private static MessageMapper.FetchType reduce(Collection<MessageMapper.FetchType> fetchTypes) {
        boolean full = fetchTypes.contains((Object)MessageMapper.FetchType.FULL);
        boolean headers = fetchTypes.contains((Object)MessageMapper.FetchType.HEADERS);
        boolean headersWithAttachmentsMetadata = fetchTypes.contains((Object)MessageMapper.FetchType.ATTACHMENTS_METADATA);
        if (full) {
            return MessageMapper.FetchType.FULL;
        }
        if (headersWithAttachmentsMetadata) {
            return MessageMapper.FetchType.ATTACHMENTS_METADATA;
        }
        if (headers) {
            return MessageMapper.FetchType.HEADERS;
        }
        return MessageMapper.FetchType.METADATA;
    }

    private static MessageMapper.FetchType toFetchType(FetchGroup.Profile profile) {
        switch (profile) {
            case HEADERS: {
                return MessageMapper.FetchType.HEADERS;
            }
            case HEADERS_WITH_ATTACHMENTS_METADATA: {
                return MessageMapper.FetchType.ATTACHMENTS_METADATA;
            }
            case BODY_CONTENT: 
            case FULL_CONTENT: 
            case MIME_CONTENT: 
            case MIME_HEADERS: 
            case MIME_DESCRIPTOR: {
                return MessageMapper.FetchType.FULL;
            }
        }
        throw new NotImplementedException("Unsupported FetchGroup Profile" + String.valueOf(profile));
    }
}

