/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.config;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.config.PrometheusPropertiesException;
import io.prometheus.metrics.config.Util;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;

public class ExporterPushgatewayProperties {
    private static final String ADDRESS = "address";
    private static final String JOB = "job";
    private static final String SCHEME = "scheme";
    private static final String ESCAPING_SCHEME = "escapingScheme";
    private static final String READ_TIMEOUT = "readTimeoutSeconds";
    private static final String CONNECT_TIMEOUT = "connectTimeoutSeconds";
    private static final String PREFIX = "io.prometheus.exporter.pushgateway";
    @Nullable
    private final String scheme;
    @Nullable
    private final String address;
    @Nullable
    private final String job;
    @Nullable
    private final EscapingScheme escapingScheme;
    @Nullable
    private final Duration connectTimeout;
    @Nullable
    private final Duration readTimeout;

    private ExporterPushgatewayProperties(@Nullable String address, @Nullable String job, @Nullable String scheme, @Nullable EscapingScheme escapingScheme, @Nullable Duration connectTimeout, @Nullable Duration readTimeout) {
        this.address = address;
        this.job = job;
        this.scheme = scheme;
        this.escapingScheme = escapingScheme;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Nullable
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public String getJob() {
        return this.job;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Nullable
    public EscapingScheme getEscapingScheme() {
        return this.escapingScheme;
    }

    @Nullable
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Nullable
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    static ExporterPushgatewayProperties load(Map<Object, Object> properties) throws PrometheusPropertiesException {
        String address = Util.loadString("io.prometheus.exporter.pushgateway.address", properties);
        String job = Util.loadString("io.prometheus.exporter.pushgateway.job", properties);
        String scheme = Util.loadString("io.prometheus.exporter.pushgateway.scheme", properties);
        String escapingScheme = Util.loadString("io.prometheus.exporter.pushgateway.escapingScheme", properties);
        Duration connectTimeout = Util.loadOptionalDuration("io.prometheus.exporter.pushgateway.connectTimeoutSeconds", properties);
        Duration readTimeout = Util.loadOptionalDuration("io.prometheus.exporter.pushgateway.readTimeoutSeconds", properties);
        if (scheme != null && !scheme.equals("http") && !scheme.equals("https")) {
            throw new PrometheusPropertiesException(String.format("%s.%s: Illegal value. Expecting 'http' or 'https'. Found: %s", PREFIX, SCHEME, scheme));
        }
        return new ExporterPushgatewayProperties(address, job, scheme, ExporterPushgatewayProperties.parseEscapingScheme(escapingScheme), connectTimeout, readTimeout);
    }

    @Nullable
    private static EscapingScheme parseEscapingScheme(@Nullable String scheme) {
        if (scheme == null) {
            return null;
        }
        switch (scheme) {
            case "allow-utf-8": {
                return EscapingScheme.ALLOW_UTF8;
            }
            case "values": {
                return EscapingScheme.VALUE_ENCODING_ESCAPING;
            }
            case "underscores": {
                return EscapingScheme.UNDERSCORE_ESCAPING;
            }
            case "dots": {
                return EscapingScheme.DOTS_ESCAPING;
            }
        }
        throw new PrometheusPropertiesException(String.format("%s.%s: Illegal value. Expecting 'allow-utf-8', 'values', 'underscores', or 'dots'. Found: %s", PREFIX, ESCAPING_SCHEME, scheme));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private String address;
        @Nullable
        private String job;
        @Nullable
        private String scheme;
        @Nullable
        private EscapingScheme escapingScheme;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private Duration readTimeout;

        private Builder() {
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        public Builder job(String job) {
            this.job = job;
            return this;
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder escapingScheme(EscapingScheme escapingScheme) {
            this.escapingScheme = escapingScheme;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public ExporterPushgatewayProperties build() {
            return new ExporterPushgatewayProperties(this.address, this.job, this.scheme, this.escapingScheme, this.connectTimeout, this.readTimeout);
        }
    }
}

