/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Transport;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public interface ClientConnectionFactory {
    public static final String CONTEXT_KEY = ClientConnectionFactory.class.getName();

    public Connection newConnection(EndPoint var1, Map<String, Object> var2) throws IOException;

    default public Connection customize(Connection connection, Map<String, Object> context2) {
        ContainerLifeCycle client = (ContainerLifeCycle)context2.get("org.eclipse.jetty.client.HttpClient");
        if (client != null) {
            client.getBeans(EventListener.class).forEach(connection::addEventListener);
        }
        return connection;
    }

    public static abstract class Info
    extends ContainerLifeCycle {
        private final ClientConnectionFactory factory;

        public Info(ClientConnectionFactory factory) {
            this.factory = factory;
            this.installBean(factory);
        }

        public Transport getTransport() {
            return Transport.TCP_IP;
        }

        public abstract List<String> getProtocols(boolean var1);

        public ClientConnectionFactory getClientConnectionFactory() {
            return this.factory;
        }

        public boolean matches(List<String> candidates, boolean secure) {
            return this.getProtocols(secure).stream().anyMatch(p -> candidates.stream().anyMatch(c -> c.equalsIgnoreCase((String)p)));
        }

        public void upgrade(EndPoint endPoint, Map<String, Object> context2) {
            throw new UnsupportedOperationException(String.valueOf(this) + " does not support upgrade to another protocol");
        }
    }

    public static interface Decorator {
        public static final String CONTEXT_KEY = Decorator.class.getName();

        public ClientConnectionFactory apply(ClientConnectionFactory var1);
    }

    public static class Wrapper
    implements ClientConnectionFactory {
        private final ClientConnectionFactory wrapped;

        public Wrapper(ClientConnectionFactory wrapped) {
            this.wrapped = wrapped;
        }

        public ClientConnectionFactory getWrapped() {
            return this.wrapped;
        }

        @Override
        public Connection newConnection(EndPoint endPoint, Map<String, Object> context2) throws IOException {
            return this.getWrapped().newConnection(endPoint, context2);
        }

        @Override
        public Connection customize(Connection connection, Map<String, Object> context2) {
            return this.getWrapped().customize(connection, context2);
        }
    }
}

