/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.modifiers.UserParameters;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=5)
@TestElementMetadata(labelResource="user_parameters_title")
public class UserParametersGui
extends AbstractPreProcessorGui {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(UserParametersGui.class);
    private static final String NAME_COL_RESOURCE = "name";
    private static final String USER_COL_RESOURCE = "user";
    private static final String UNDERSCORE = "_";
    private JTable paramTable;
    private PowerTableModel tableModel;
    private static final int numUserColumns = 1;
    private JButton addParameterButton;
    private JButton addUserButton;
    private JButton deleteRowButton;
    private JButton deleteColumnButton;
    private JButton moveRowUpButton;
    private JButton moveRowDownButton;
    private JCheckBox perIterationCheck;
    private JPanel paramPanel;

    public UserParametersGui() {
        this.init();
    }

    public String getLabelResource() {
        return "user_parameters_title";
    }

    public void configure(TestElement el) {
        this.initTableModel();
        this.paramTable.setModel((TableModel)this.tableModel);
        UserParameters params = (UserParameters)el;
        CollectionProperty names = params.getNames();
        CollectionProperty threadValues = params.getThreadLists();
        this.tableModel.setColumnData(0, (List)names.getObjectValue());
        PropertyIterator iter = threadValues.iterator();
        if (iter.hasNext()) {
            this.tableModel.setColumnData(1, (List)iter.next().getObjectValue());
        }
        int count = 2;
        while (iter.hasNext()) {
            String colName = UserParametersGui.getUserColName(count);
            this.tableModel.addNewColumn(colName, String.class);
            this.tableModel.setColumnData(count, (List)iter.next().getObjectValue());
            ++count;
        }
        this.setColumnWidths();
        this.perIterationCheck.setSelected(params.isPerIteration());
        super.configure(el);
    }

    public TestElement createTestElement() {
        UserParameters params = new UserParameters();
        this.modifyTestElement((TestElement)params);
        return params;
    }

    public void modifyTestElement(TestElement params) {
        GuiUtils.stopTableEditing((JTable)this.paramTable);
        UserParameters userParams = (UserParameters)params;
        userParams.setNames(new CollectionProperty("UserParameters.names", (Collection)this.tableModel.getColumnData(NAME_COL_RESOURCE)));
        CollectionProperty threadLists = new CollectionProperty("UserParameters.thread_values", new ArrayList());
        log.debug("making threadlists from gui");
        for (int col = 1; col < this.tableModel.getColumnCount(); ++col) {
            threadLists.addItem((Object)this.tableModel.getColumnData(UserParametersGui.getUserColName(col)));
            if (!log.isDebugEnabled()) continue;
            log.debug("Adding column to threadlist: {}", (Object)this.tableModel.getColumnData(UserParametersGui.getUserColName(col)));
            log.debug("Threadlists now = {}", (Object)threadLists);
        }
        if (log.isDebugEnabled()) {
            log.debug("In the end, threadlists = {}", (Object)threadLists);
        }
        userParams.setThreadLists(threadLists);
        userParams.setPerIteration(this.perIterationCheck.isSelected());
        super.configureTestElement(params);
    }

    public void clearGui() {
        super.clearGui();
        this.initTableModel();
        this.paramTable.setModel((TableModel)this.tableModel);
        HeaderAsPropertyRenderer defaultRenderer = new HeaderAsPropertyRenderer(){
            private static final long serialVersionUID = 240L;

            protected String getText(Object value, int row, int column) {
                String val;
                if (column >= 1 && (val = value.toString()).startsWith("user_")) {
                    return JMeterUtils.getResString((String)UserParametersGui.USER_COL_RESOURCE) + val.substring(val.indexOf(UserParametersGui.UNDERSCORE));
                }
                return super.getText(value, row, column);
            }
        };
        this.paramTable.getTableHeader().setDefaultRenderer((TableCellRenderer)defaultRenderer);
        this.perIterationCheck.setSelected(false);
    }

    private static String getUserColName(int user) {
        return "user_" + user;
    }

    private void init() {
        this.setBorder(this.makeBorder());
        this.setLayout(new BorderLayout());
        VerticalPanel vertPanel = new VerticalPanel();
        vertPanel.add(this.makeTitlePanel());
        this.perIterationCheck = new JCheckBox(JMeterUtils.getResString((String)"update_per_iter"), true);
        Box perIterationPanel = Box.createHorizontalBox();
        perIterationPanel.add(this.perIterationCheck);
        perIterationPanel.add(Box.createHorizontalGlue());
        vertPanel.add(perIterationPanel);
        this.add((Component)vertPanel, "North");
        this.add(this.makeParameterPanel(), "Center");
    }

    private JPanel makeParameterPanel() {
        JLabel tableLabel = new JLabel(JMeterUtils.getResString((String)"user_parameters_table"));
        this.initTableModel();
        this.paramTable = new JTable((TableModel)this.tableModel);
        this.paramTable.setSelectionMode(2);
        this.paramTable.setAutoResizeMode(0);
        JMeterUtils.applyHiDPI((JTable)this.paramTable);
        this.paramPanel = new JPanel(new BorderLayout());
        this.paramPanel.add((Component)tableLabel, "North");
        JScrollPane scroll = new JScrollPane(this.paramTable);
        scroll.setPreferredSize(scroll.getMinimumSize());
        this.paramPanel.add((Component)scroll, "Center");
        this.paramPanel.add((Component)this.makeButtonPanel(), "South");
        return this.paramPanel;
    }

    protected void initTableModel() {
        this.tableModel = new PowerTableModel(new String[]{NAME_COL_RESOURCE, UserParametersGui.getUserColName(1)}, new Class[]{String.class, String.class});
    }

    private JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(2, 2));
        this.addParameterButton = new JButton(JMeterUtils.getResString((String)"add_parameter"));
        this.addUserButton = new JButton(JMeterUtils.getResString((String)"add_user"));
        this.deleteRowButton = new JButton(JMeterUtils.getResString((String)"delete_parameter"));
        this.deleteColumnButton = new JButton(JMeterUtils.getResString((String)"delete_user"));
        this.moveRowUpButton = new JButton(JMeterUtils.getResString((String)"up"));
        this.moveRowDownButton = new JButton(JMeterUtils.getResString((String)"down"));
        buttonPanel.add(this.addParameterButton);
        buttonPanel.add(this.deleteRowButton);
        buttonPanel.add(this.moveRowUpButton);
        buttonPanel.add(this.addUserButton);
        buttonPanel.add(this.deleteColumnButton);
        buttonPanel.add(this.moveRowDownButton);
        this.addParameterButton.addActionListener(new AddParamAction());
        this.addUserButton.addActionListener(new AddUserAction());
        this.deleteRowButton.addActionListener(new DeleteRowAction());
        this.deleteColumnButton.addActionListener(new DeleteColumnAction());
        this.moveRowUpButton.addActionListener(new MoveRowUpAction());
        this.moveRowDownButton.addActionListener(new MoveRowDownAction());
        return buttonPanel;
    }

    private void setColumnWidths() {
        int margin = 10;
        int minwidth = 150;
        JTableHeader tableHeader = this.paramTable.getTableHeader();
        FontMetrics headerFontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            int headerWidth = headerFontMetrics.stringWidth(this.paramTable.getColumnName(i));
            int maxWidth = this.getMaximalRequiredColumnWidth(i, headerWidth);
            this.paramTable.getColumnModel().getColumn(i).setPreferredWidth(Math.max(maxWidth + margin, minwidth));
        }
    }

    private int getMaximalRequiredColumnWidth(int columnIndex, int headerWidth) {
        int maxWidth = headerWidth;
        TableColumn column = this.paramTable.getColumnModel().getColumn(columnIndex);
        TableCellRenderer cellRenderer = column.getCellRenderer();
        if (cellRenderer == null) {
            cellRenderer = new DefaultTableCellRenderer();
        }
        for (int row = 0; row < this.paramTable.getModel().getRowCount(); ++row) {
            Component rendererComponent = cellRenderer.getTableCellRendererComponent(this.paramTable, this.paramTable.getModel().getValueAt(row, columnIndex), false, false, row, columnIndex);
            double valueWidth = rendererComponent.getPreferredSize().getWidth();
            maxWidth = (int)Math.max((double)maxWidth, valueWidth);
        }
        return maxWidth;
    }

    private class AddParamAction
    implements ActionListener {
        private AddParamAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.stopTableEditing((JTable)UserParametersGui.this.paramTable);
            UserParametersGui.this.tableModel.addNewRow();
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.deleteRowButton.setEnabled(true);
            int rowToSelect = UserParametersGui.this.tableModel.getRowCount() - 1;
            UserParametersGui.this.paramTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        }
    }

    private class AddUserAction
    implements ActionListener {
        private AddUserAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.stopTableEditing((JTable)UserParametersGui.this.paramTable);
            UserParametersGui.this.tableModel.addNewColumn(UserParametersGui.getUserColName(UserParametersGui.this.tableModel.getColumnCount()), String.class);
            UserParametersGui.this.tableModel.fireTableDataChanged();
            UserParametersGui.this.setColumnWidths();
            UserParametersGui.this.deleteColumnButton.setEnabled(true);
            int colToSelect = UserParametersGui.this.tableModel.getColumnCount() - 1;
            UserParametersGui.this.paramTable.setColumnSelectionInterval(colToSelect, colToSelect);
        }
    }

    private class DeleteRowAction
    implements ActionListener {
        private DeleteRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.cancelEditing((JTable)UserParametersGui.this.paramTable);
            int[] rowsSelected = UserParametersGui.this.paramTable.getSelectedRows();
            if (rowsSelected.length > 0) {
                for (int i = rowsSelected.length - 1; i >= 0; --i) {
                    UserParametersGui.this.tableModel.removeRow(rowsSelected[i]);
                }
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getRowCount() == 0) {
                    UserParametersGui.this.deleteRowButton.setEnabled(false);
                }
            } else if (UserParametersGui.this.tableModel.getRowCount() > 0) {
                UserParametersGui.this.tableModel.removeRow(0);
                UserParametersGui.this.tableModel.fireTableDataChanged();
            }
        }
    }

    private class DeleteColumnAction
    implements ActionListener {
        private DeleteColumnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiUtils.cancelEditing((JTable)UserParametersGui.this.paramTable);
            int colSelected = UserParametersGui.this.paramTable.getSelectedColumn();
            if (colSelected == 0 || colSelected == 1) {
                JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"column_delete_disallowed"), "Error", 0);
                return;
            }
            if (colSelected >= 0) {
                UserParametersGui.this.tableModel.removeColumn(colSelected);
                UserParametersGui.this.tableModel.fireTableDataChanged();
                if (UserParametersGui.this.tableModel.getColumnCount() == 0) {
                    UserParametersGui.this.deleteColumnButton.setEnabled(false);
                } else {
                    if (colSelected >= UserParametersGui.this.tableModel.getColumnCount()) {
                        --colSelected;
                    }
                    UserParametersGui.this.paramTable.setColumnSelectionInterval(colSelected, colSelected);
                }
                UserParametersGui.this.setColumnWidths();
            }
        }
    }

    private class MoveRowUpAction
    implements ActionListener {
        private MoveRowUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rowsSelected = UserParametersGui.this.paramTable.getSelectedRows();
            GuiUtils.stopTableEditing((JTable)UserParametersGui.this.paramTable);
            if (rowsSelected.length > 0 && rowsSelected[0] > 0) {
                for (int rowSelected : rowsSelected) {
                    UserParametersGui.this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected - 1);
                }
                for (int rowSelected : rowsSelected) {
                    UserParametersGui.this.paramTable.addRowSelectionInterval(rowSelected - 1, rowSelected - 1);
                }
            }
        }
    }

    private class MoveRowDownAction
    implements ActionListener {
        private MoveRowDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rowsSelected = UserParametersGui.this.paramTable.getSelectedRows();
            GuiUtils.stopTableEditing((JTable)UserParametersGui.this.paramTable);
            if (rowsSelected.length > 0 && rowsSelected[rowsSelected.length - 1] < UserParametersGui.this.paramTable.getRowCount() - 1) {
                for (int i = rowsSelected.length - 1; i >= 0; --i) {
                    int rowSelected = rowsSelected[i];
                    UserParametersGui.this.tableModel.moveRow(rowSelected, rowSelected + 1, rowSelected + 1);
                }
                for (int rowSelected : rowsSelected) {
                    UserParametersGui.this.paramTable.addRowSelectionInterval(rowSelected + 1, rowSelected + 1);
                }
            }
        }
    }
}

