/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.List;

public class ToNumberFunction
extends BaseFunction {
    public ToNumberFunction() {
        super(ArgumentConstraints.anyValue());
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        T subject = arguments.get(0).value();
        JmesPathType subjectType = runtime.typeOf(subject);
        if (subjectType == JmesPathType.NUMBER) {
            return subject;
        }
        if (subjectType == JmesPathType.STRING) {
            try {
                double d = Double.parseDouble(runtime.toString(subject));
                if (d == Math.rint(d)) {
                    return runtime.createNumber((long)d);
                }
                return runtime.createNumber(d);
            }
            catch (NumberFormatException nfe) {
                return runtime.createNull();
            }
        }
        return runtime.createNull();
    }
}

