/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberSlotted
implements ICSSSelectorMember,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final CSSSelector m_aSelector;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberSlotted(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"Selector");
        this.m_aSelector = cSSSelector;
    }

    @Nonnull
    public final CSSSelector getSelector() {
        return this.m_aSelector;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        StringBuilder stringBuilder = new StringBuilder("::slotted(");
        stringBuilder.append(this.m_aSelector.getAsCSSString(iCSSWriterSettings, 0));
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberSlotted cSSSelectorMemberSlotted = (CSSSelectorMemberSlotted)object;
        return this.m_aSelector.equals(cSSSelectorMemberSlotted.m_aSelector);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSelector).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Selector", (Object)this.m_aSelector).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

