/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters(returns="FluentDateAssertion<R>")
public class FluentDateAssertion<R>
extends FluentComparableAssertion<R> {
    private final Date value;

    public FluentDateAssertion(Date value, R returns) {
        this(null, value, returns);
    }

    public FluentDateAssertion(Assertion creator, Date value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    public R isEqual(Date value, ChronoUnit precision) throws AssertionError {
        if (ObjectUtils.ne(this.value, value, (x, y) -> x.toInstant().truncatedTo(precision).equals(y.toInstant().truncatedTo(precision)))) {
            throw this.error("Unexpected value.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isAfter(Date value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (!this.value.after(value)) {
            throw this.error("Value was not after expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isAfterNow() throws AssertionError {
        return this.isAfter(new Date());
    }

    public R isBefore(Date value) throws AssertionError {
        this.exists();
        this.assertNotNull("value", value);
        if (!this.value.before(value)) {
            throw this.error("Value was not before expected.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.value);
        }
        return this.returns();
    }

    public R isBeforeNow() throws AssertionError {
        return this.isBefore(new Date());
    }

    public R isBetween(Date lower, Date upper) throws AssertionError {
        this.exists();
        this.assertNotNull("lower", lower);
        this.assertNotNull("upper", upper);
        this.isBefore(upper);
        this.isAfter(lower);
        return this.returns();
    }

    @Override
    public FluentDateAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentDateAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentDateAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

