/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters(returns="FluentLongAssertion<R>")
public class FluentLongAssertion<R>
extends FluentComparableAssertion<R> {
    private final Long value;

    public FluentLongAssertion(Long value, R returns) {
        this(null, value, returns);
    }

    public FluentLongAssertion(Assertion creator, Long value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    public FluentIntegerAssertion<R> integer() {
        return new FluentIntegerAssertion((Assertion)this, this.value == null ? null : Integer.valueOf(this.value.intValue()), this.returns());
    }

    @Override
    protected int compareTo(Object value) {
        return this.value.compareTo(((Number)value).longValue());
    }

    @Override
    protected Object equivalent(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return o;
    }

    @Override
    public FluentLongAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentLongAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentLongAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

