/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.function.Predicate;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;

@FluentSetters(returns="FluentThrowableAssertion<R>")
public class FluentThrowableAssertion<R>
extends FluentAssertion<R> {
    private final Throwable value;

    public FluentThrowableAssertion(Throwable value, R returns) {
        this(null, value, returns);
    }

    public FluentThrowableAssertion(Assertion creator, Throwable value, R returns) {
        super(creator, returns);
        this.value = value;
    }

    public R isType(Class<?> type) {
        this.assertNotNull("type", type);
        if (!type.isInstance(this.value)) {
            throw this.error("Exception was not expected type.\n\tExpected=[{0}]\n\tActual=[{1}]", FluentThrowableAssertion.className(type), FluentThrowableAssertion.className(this.value));
        }
        return this.returns();
    }

    public R contains(String ... substrings) {
        this.assertNotNull("substrings", substrings);
        this.exists();
        for (String substring : substrings) {
            boolean found;
            if (substring == null) continue;
            Throwable e2 = this.value;
            for (found = false; e2 != null && !found; found |= StringUtils.contains(e2.getMessage(), substring), e2 = e2.getCause()) {
            }
            if (found) continue;
            throw this.error("Exception message did not contain expected substring.\n\tSubstring=[{0}]\n\tText=[{1}]", substring, this.value.getMessage());
        }
        return this.returns();
    }

    public R is(String msg) {
        return this.message().is(msg);
    }

    public R exists() {
        if (this.value == null) {
            throw this.error("Exception was not thrown.", new Object[0]);
        }
        return this.returns();
    }

    public R doesNotExist() {
        if (this.value != null) {
            throw this.error("Exception was thrown.", new Object[0]);
        }
        return this.returns();
    }

    public R passes(Predicate<Throwable> test) throws AssertionError {
        if (!test.test(this.value)) {
            throw this.error("Value did not pass predicate test.\n\tValue=[{0}]", this.value);
        }
        return this.returns();
    }

    public <T extends Throwable> R passes(Class<T> c, Predicate<T> test) throws AssertionError {
        this.isType(c);
        if (!test.test(this.value)) {
            throw this.error("Value did not pass predicate test.\n\tValue=[{0}]", this.value);
        }
        return this.returns();
    }

    public FluentStringAssertion<R> message() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : this.value.getMessage(), this.returns());
    }

    public FluentStringAssertion<R> localizedMessage() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : this.value.getLocalizedMessage(), this.returns());
    }

    public FluentStringAssertion<R> stackTrace() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : StringUtils.getStackTrace(this.value), this.returns());
    }

    public FluentThrowableAssertion<R> causedBy() {
        return new FluentThrowableAssertion(this, this.value == null ? null : this.value.getCause(), this.returns());
    }

    public FluentThrowableAssertion<R> find(Class<?> throwableClass) {
        for (Throwable t = this.value; t != null; t = t.getCause()) {
            if (!throwableClass.isInstance(t)) continue;
            return new FluentThrowableAssertion(this, t, this.returns());
        }
        return new FluentThrowableAssertion(this, null, this.returns());
    }

    @Override
    public FluentThrowableAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentThrowableAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentThrowableAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

