/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.BasicIllegalArgumentException;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.internal.StringUtils;

@Header(type="integer", format="int64")
public class BasicLongHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private Long parsed;

    public static BasicLongHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicLongHeader(name, value);
    }

    public static BasicLongHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicLongHeader(name, value);
    }

    public BasicLongHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.getParsedValue();
        }
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.asLong());
    }

    public Long asLong() {
        return this.getParsedValue();
    }

    public FluentLongAssertion<BasicLongHeader> assertLong() {
        return new FluentLongAssertion<BasicLongHeader>(this.asLong(), this);
    }

    private Long getParsedValue() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        String s = o.toString();
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            throw new BasicIllegalArgumentException("Value could not be parsed as a long: {0}", o);
        }
    }
}

