/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.BeanTraverseBuilder;
import org.apache.juneau.BeanTraverseSession;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;

@ConfigurableContext
public abstract class BeanTraverseContext
extends BeanContext {
    static final String PREFIX = "BeanTraverseContext";
    public static final String BEANTRAVERSE_detectRecursions = "BeanTraverseContext.detectRecursions.b";
    public static final String BEANTRAVERSE_ignoreRecursions = "BeanTraverseContext.ignoreRecursions.b";
    public static final String BEANTRAVERSE_initialDepth = "BeanTraverseContext.initialDepth.i";
    public static final String BEANTRAVERSE_maxDepth = "BeanTraverseContext.maxDepth.i";
    private final int initialDepth;
    private final int maxDepth = this.getIntegerProperty("BeanTraverseContext.maxDepth.i", 100);
    private final boolean detectRecursions;
    private final boolean ignoreRecursions;

    protected BeanTraverseContext(PropertyStore ps) {
        super(ps);
        this.initialDepth = this.getIntegerProperty(BEANTRAVERSE_initialDepth, 0);
        this.ignoreRecursions = this.getBooleanProperty(BEANTRAVERSE_ignoreRecursions, false);
        this.detectRecursions = this.getBooleanProperty(BEANTRAVERSE_detectRecursions, this.ignoreRecursions);
    }

    @Override
    public BeanTraverseBuilder builder() {
        return null;
    }

    @Override
    public BeanTraverseSession createSession() {
        return new BeanTraverseSession(this, this.createDefaultSessionArgs());
    }

    @Override
    public BeanTraverseSession createSession(BeanSessionArgs args) {
        return new BeanTraverseSession(this, args);
    }

    protected final boolean isDetectRecursions() {
        return this.detectRecursions;
    }

    protected final boolean isIgnoreRecursions() {
        return this.ignoreRecursions;
    }

    protected final int getInitialDepth() {
        return this.initialDepth;
    }

    protected final int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("detectRecursions", this.detectRecursions).a("maxDepth", this.maxDepth).a("ignoreRecursions", this.ignoreRecursions).a("initialDepth", this.initialDepth));
    }
}

