/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.nio.charset.Charset;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;

@FluentSetters(returns="FluentByteArrayAssertion<R>")
public class FluentByteArrayAssertion<R>
extends FluentArrayAssertion<R> {
    private byte[] value;

    public FluentByteArrayAssertion(byte[] contents, R returns) {
        this((Assertion)null, contents, returns);
    }

    public FluentByteArrayAssertion(Assertion creator, byte[] contents, R returns) {
        super(creator, contents, returns);
        this.value = contents;
    }

    @Override
    public FluentStringAssertion<R> string() {
        return this.string(IOUtils.UTF8);
    }

    public FluentStringAssertion<R> string(Charset cs) {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : new String(this.value, cs), this.returns());
    }

    public FluentStringAssertion<R> base64() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : StringUtils.base64Encode(this.value), this.returns());
    }

    public FluentStringAssertion<R> hex() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : StringUtils.toHex(this.value), this.returns());
    }

    public FluentStringAssertion<R> spacedHex() {
        return new FluentStringAssertion((Assertion)this, this.value == null ? null : StringUtils.toSpacedHex(this.value), this.returns());
    }

    @Override
    public FluentByteArrayAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

