/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.function.Supplier;
import org.apache.juneau.http.MediaRange;
import org.apache.juneau.http.MediaRanges;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.internal.StringUtils;

public class BasicMediaRangeArrayHeader
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private MediaRanges parsed;

    public static BasicMediaRangeArrayHeader of(String name, Object value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicMediaRangeArrayHeader(name, value);
    }

    public static BasicMediaRangeArrayHeader of(String name, Supplier<?> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicMediaRangeArrayHeader(name, value);
    }

    public BasicMediaRangeArrayHeader(String name, Object value) {
        super(name, value);
        if (!this.isSupplier(value)) {
            this.parsed = this.parse();
        }
    }

    public MediaRanges asMediaRanges() {
        return this.parse();
    }

    public int match(List<? extends MediaType> mediaTypes) {
        return this.asMediaRanges().match(mediaTypes);
    }

    public MediaRange getRange(int index) {
        return this.asMediaRanges().getRange(index);
    }

    public boolean hasSubtypePart(String part) {
        return this.asMediaRanges().hasSubtypePart(part);
    }

    public List<MediaRange> getRanges() {
        return this.asMediaRanges().getRanges();
    }

    @Override
    public String getValue() {
        Object o = this.getRawValue();
        if (o == null) {
            return null;
        }
        return StringUtils.stringify(this.asMediaRanges());
    }

    private MediaRanges parse() {
        if (this.parsed != null) {
            return this.parsed;
        }
        Object o = this.getRawValue();
        if (o == null) {
            o = "";
        }
        if (o instanceof MediaRanges) {
            return (MediaRanges)o;
        }
        return MediaRanges.of(o.toString());
    }
}

