/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.json.JsonSchemaSerializerBuilder;
import org.apache.juneau.json.JsonSchemaSerializerSession;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.JsonSchemaMetaProvider;
import org.apache.juneau.serializer.SerializerSessionArgs;

@ConfigurableContext
public class JsonSchemaSerializer
extends JsonSerializer
implements JsonSchemaMetaProvider {
    static final String PREFIX = "JsonSchemaSerializer";
    public static final JsonSchemaSerializer DEFAULT = new JsonSchemaSerializer(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_READABLE = new Readable(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_SIMPLE = new Simple(PropertyStore.DEFAULT);
    public static final JsonSchemaSerializer DEFAULT_SIMPLE_READABLE = new SimpleReadable(PropertyStore.DEFAULT);
    private final JsonSchemaGenerator generator;
    private final Map<ClassMeta<?>, JsonSchemaClassMeta> jsonSchemaClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonSchemaBeanPropertyMeta> jsonSchemaBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonSchemaBeanPropertyMeta>();

    public JsonSchemaSerializer(PropertyStore ps) {
        super(ps.builder().setDefault("BeanTraverseContext.detectRecursions.b", true).setDefault("BeanTraverseContext.ignoreRecursions.b", true).build(), "application/json", "application/json+schema,text/json+schema");
        this.generator = JsonSchemaGenerator.create().apply(this.getPropertyStore()).build();
    }

    @Override
    public JsonSchemaSerializerBuilder builder() {
        return new JsonSchemaSerializerBuilder(this.getPropertyStore());
    }

    public static JsonSchemaSerializerBuilder create() {
        return new JsonSchemaSerializerBuilder();
    }

    @Override
    public JsonSchemaSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsonSchemaSerializerSession createSession(SerializerSessionArgs args) {
        return new JsonSchemaSerializerSession(this, args);
    }

    JsonSchemaGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        JsonSchemaClassMeta m = this.jsonSchemaClassMetas.get(cm);
        if (m == null) {
            m = new JsonSchemaClassMeta(cm, this);
            this.jsonSchemaClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        JsonSchemaBeanPropertyMeta m = this.jsonSchemaBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonSchemaBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsonSchemaBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap().a("generator", this.generator));
    }

    public static class SimpleReadable
    extends JsonSchemaSerializer {
        public SimpleReadable(PropertyStore ps) {
            super(ps.builder().setDefault("JsonSerializer.simpleMode.b", true).setDefault("WriterSerializer.quoteChar.s", Character.valueOf('\'')).setDefault("WriterSerializer.useWhitespace.b", true).build());
        }
    }

    public static class Simple
    extends JsonSchemaSerializer {
        public Simple(PropertyStore ps) {
            super(ps.builder().setDefault("JsonSerializer.simpleMode.b", true).setDefault("WriterSerializer.quoteChar.s", Character.valueOf('\'')).build());
        }
    }

    public static class Readable
    extends JsonSchemaSerializer {
        public Readable(PropertyStore ps) {
            super(ps.builder().setDefault("WriterSerializer.useWhitespace.b", true).build());
        }
    }
}

