/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.oapi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartFormat;
import org.apache.juneau.oapi.OpenApiBeanPropertyMeta;
import org.apache.juneau.oapi.OpenApiClassMeta;
import org.apache.juneau.oapi.OpenApiCommon;
import org.apache.juneau.oapi.OpenApiMetaProvider;
import org.apache.juneau.oapi.OpenApiSerializerBuilder;
import org.apache.juneau.oapi.OpenApiSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.uon.UonSerializer;

@ConfigurableContext
public class OpenApiSerializer
extends UonSerializer
implements OpenApiMetaProvider,
OpenApiCommon {
    static final String PREFIX = "OpenApiSerializer";
    public static final OpenApiSerializer DEFAULT = new OpenApiSerializer(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, OpenApiClassMeta> openApiClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, OpenApiBeanPropertyMeta> openApiBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, OpenApiBeanPropertyMeta>();
    private final HttpPartFormat format = this.getProperty("OpenApi.format.s", HttpPartFormat.class, HttpPartFormat.NO_FORMAT);
    private final HttpPartCollectionFormat collectionFormat = this.getProperty("OpenApi.collectionformat.s", HttpPartCollectionFormat.class, HttpPartCollectionFormat.NO_COLLECTION_FORMAT);

    public OpenApiSerializer(PropertyStore ps, String produces, String accept) {
        super(ps.builder().setDefault("UonSerializer.encoding.b", false).build(), produces, accept);
    }

    public OpenApiSerializer(PropertyStore ps) {
        this(ps, "text/openapi", null);
    }

    @Override
    public OpenApiSerializerBuilder builder() {
        return new OpenApiSerializerBuilder(this.getPropertyStore());
    }

    public static OpenApiSerializerBuilder create() {
        return new OpenApiSerializerBuilder();
    }

    @Override
    public OpenApiSerializerSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public OpenApiSerializerSession createSession(SerializerSessionArgs args) {
        return new OpenApiSerializerSession(this, args);
    }

    @Override
    public OpenApiSerializerSession createPartSession(SerializerSessionArgs args) {
        return new OpenApiSerializerSession(this, args);
    }

    @Override
    public OpenApiClassMeta getOpenApiClassMeta(ClassMeta<?> cm) {
        OpenApiClassMeta m = this.openApiClassMetas.get(cm);
        if (m == null) {
            m = new OpenApiClassMeta(cm, this);
            this.openApiClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public OpenApiBeanPropertyMeta getOpenApiBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return OpenApiBeanPropertyMeta.DEFAULT;
        }
        OpenApiBeanPropertyMeta m = this.openApiBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new OpenApiBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.openApiBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    protected final HttpPartFormat getFormat() {
        return this.format;
    }

    protected final HttpPartCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }
}

