/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.ConfigApply;
import org.apache.juneau.PropertyStoreBuilder;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.svl.VarResolverSession;

public class HtmlDocConfigApply
extends ConfigApply<HtmlDocConfig> {
    private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

    public HtmlDocConfigApply(Class<HtmlDocConfig> c, VarResolverSession r) {
        super(c, r);
    }

    @Override
    public void apply(AnnotationInfo<HtmlDocConfig> ai, PropertyStoreBuilder psb) {
        HtmlDocConfig a = ai.getAnnotation();
        if (a.aside().length > 0) {
            psb.set("HtmlDocSerializer.aside.ls", this.resolveList(a.aside(), psb.peek(String[].class, "HtmlDocSerializer.aside.ls")));
        }
        if (!"DEFAULT".equalsIgnoreCase(a.asideFloat())) {
            psb.set("HtmlDocSerializer.asideFloat.s", a.asideFloat().toUpperCase());
        }
        if (a.footer().length > 0) {
            psb.set("HtmlDocSerializer.footer.ls", this.resolveList(a.footer(), psb.peek(String[].class, "HtmlDocSerializer.footer.ls")));
        }
        if (a.head().length > 0) {
            psb.set("HtmlDocSerializer.head.ls", this.resolveList(a.head(), psb.peek(String[].class, "HtmlDocSerializer.head.ls")));
        }
        if (a.header().length > 0) {
            psb.set("HtmlDocSerializer.header.ls", this.resolveList(a.header(), psb.peek(String[].class, "HtmlDocSerializer.header.ls")));
        }
        if (a.nav().length > 0) {
            psb.set("HtmlDocSerializer.nav.ls", this.resolveList(a.nav(), psb.peek(String[].class, "HtmlDocSerializer.nav.ls")));
        }
        if (a.navlinks().length > 0) {
            psb.set("HtmlDocSerializer.navlinks.ls", this.resolveLinks(a.navlinks(), psb.peek(String[].class, "HtmlDocSerializer.navlinks.ls")));
        }
        if (!a.noResultsMessage().isEmpty()) {
            psb.set("HtmlDocSerializer.noResultsMessage.s", this.string(a.noResultsMessage()));
        }
        if (!a.nowrap().isEmpty()) {
            psb.set("HtmlDocSerializer.nowrap.b", this.bool(a.nowrap()));
        }
        if (a.script().length > 0) {
            psb.set("HtmlDocSerializer.script.ls", this.resolveList(a.script(), psb.peek(String[].class, "HtmlDocSerializer.script.ls")));
        }
        if (a.style().length > 0) {
            psb.set("HtmlDocSerializer.style.ls", this.resolveList(a.style(), psb.peek(String[].class, "HtmlDocSerializer.style.ls")));
        }
        if (a.stylesheet().length > 0) {
            psb.set("HtmlDocSerializer.stylesheet.ls", this.resolveList(a.stylesheet(), psb.peek(String[].class, "HtmlDocSerializer.stylesheet.ls")));
        }
        if (a.template() != HtmlDocTemplate.Null.class) {
            psb.set("HtmlDocSerializer.template.c", a.template());
        }
        for (Class<? extends HtmlWidget> w : a.widgets()) {
            try {
                psb.prependTo("HtmlDocSerializer.widgets.lo", w.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String[] resolveLinks(Object[] value, String[] prev) {
        AList<String> list = AList.of();
        for (Object v : value) {
            String s = this.string(StringUtils.stringify(v));
            if (s == null) {
                return new String[0];
            }
            if ("INHERIT".equals(s)) {
                if (prev == null) continue;
                list.a(prev);
                continue;
            }
            if (s.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(s).matches()) {
                Matcher lm = INDEXED_LINK_PATTERN.matcher(s);
                lm.matches();
                String key = lm.group(1);
                int index = Math.min(list.size(), Integer.parseInt(lm.group(2)));
                String remainder = lm.group(3);
                list.add(index, key.isEmpty() ? remainder : key + ":" + remainder);
                continue;
            }
            list.add(s);
        }
        return list.asArrayOf(String.class);
    }

    private String[] resolveList(Object[] value, String[] prev) {
        ASet<String> set = ASet.of(new String[0]);
        for (Object v : value) {
            String s = this.string(StringUtils.stringify(v));
            if ("INHERIT".equals(s)) {
                if (prev == null) continue;
                set.a((String[])prev);
                continue;
            }
            if ("NONE".equals(s)) {
                return new String[0];
            }
            set.add(s);
        }
        return set.asArrayOf(String.class);
    }
}

