/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.MediaType;

@BeanIgnore
public class MediaRange
extends MediaType {
    private final NameValuePair[] extensions;
    private final Float qValue;
    private final String string;

    public MediaRange(HeaderElement e) {
        super(e);
        Float qValue = Float.valueOf(1.0f);
        AList<NameValuePair> extensions = AList.of();
        boolean foundQ = false;
        for (NameValuePair p : e.getParameters()) {
            if (p.getName().equals("q")) {
                qValue = Float.valueOf(Float.parseFloat(p.getValue()));
                foundQ = true;
                continue;
            }
            if (!foundQ) continue;
            extensions.add(BasicNameValuePair.of(p.getName(), p.getValue()));
        }
        this.qValue = qValue;
        this.extensions = extensions.toArray(new NameValuePair[extensions.size()]);
        StringBuffer sb = new StringBuffer().append(super.toString());
        if ((double)qValue.floatValue() == 1.0) {
            if (this.extensions.length > 0) {
                sb.append(";q=").append(qValue);
                for (NameValuePair p : extensions) {
                    sb.append(';').append(p.getName()).append('=').append(p.getValue());
                }
            }
        } else {
            sb.append(";q=").append(qValue);
            for (NameValuePair p : extensions) {
                sb.append(';').append(p.getName()).append('=').append(p.getValue());
            }
        }
        this.string = sb.toString();
    }

    public Float getQValue() {
        return this.qValue;
    }

    public List<NameValuePair> getExtensions() {
        return Collections.unmodifiableList(Arrays.asList(this.extensions));
    }

    @Override
    public String toString() {
        return this.string;
    }
}

