/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AList;
import org.apache.juneau.http.Constants;
import org.apache.juneau.http.MediaRange;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class MediaRanges {
    private static final MediaRanges DEFAULT = new MediaRanges("");
    private static final Cache<String, MediaRanges> CACHE = new Cache(Constants.NOCACHE, Constants.CACHE_MAX_SIZE);
    private final MediaRange[] ranges;
    private final String string;
    private static final Comparator<MediaRange> RANGE_COMPARATOR = new Comparator<MediaRange>(){

        @Override
        public int compare(MediaRange o1, MediaRange o2) {
            int qCompare = Float.compare(o2.getQValue().floatValue(), o1.getQValue().floatValue());
            if (qCompare != 0) {
                return qCompare;
            }
            int i = o2.toString().compareTo(o1.toString());
            return i;
        }
    };

    public static MediaRanges of(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        MediaRanges mr = CACHE.get(value);
        if (mr == null) {
            mr = CACHE.put(value, new MediaRanges(value));
        }
        return mr;
    }

    public MediaRanges(String value) {
        this(MediaRanges.parse(value));
    }

    public MediaRanges(HeaderElement[] e) {
        AList<MediaRange> l = AList.of();
        for (HeaderElement e2 : e) {
            l.add(new MediaRange(e2));
        }
        l.sort(RANGE_COMPARATOR);
        this.ranges = l.toArray(new MediaRange[l.size()]);
        this.string = this.ranges.length == 1 ? this.ranges[0].toString() : StringUtils.join(l, ',');
    }

    public int match(List<? extends MediaType> mediaTypes) {
        MediaRange mr;
        float q2;
        if (this.string.isEmpty() || mediaTypes == null) {
            return -1;
        }
        int matchQuant = 0;
        int matchIndex = -1;
        float q = 0.0f;
        MediaRange[] mediaRangeArray = this.ranges;
        int n = mediaRangeArray.length;
        for (int i = 0; i < n && !((q2 = (mr = mediaRangeArray[i]).getQValue().floatValue()) < q) && q2 != 0.0f; ++i) {
            for (int i2 = 0; i2 < mediaTypes.size(); ++i2) {
                MediaType mt = mediaTypes.get(i2);
                int matchQuant2 = mr.match(mt, false);
                if (matchQuant2 <= matchQuant) continue;
                matchIndex = i2;
                matchQuant = matchQuant2;
                q = q2;
            }
        }
        return matchIndex;
    }

    public MediaRange getRange(int index) {
        if (index < 0 || index >= this.ranges.length) {
            return null;
        }
        return this.ranges[index];
    }

    public boolean hasSubtypePart(String part) {
        for (MediaRange mr : this.ranges) {
            if (!(mr.getQValue().floatValue() > 0.0f) || mr.getSubTypes().indexOf(part) < 0) continue;
            return true;
        }
        return false;
    }

    public List<MediaRange> getRanges() {
        return Collections.unmodifiableList(Arrays.asList(this.ranges));
    }

    private static HeaderElement[] parse(String value) {
        return BasicHeaderValueParser.parseElements((String)StringUtils.emptyIfNull(StringUtils.trim(value)), null);
    }

    public String toString() {
        return this.string;
    }
}

