/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.internal.StringUtils;

public class ReflectionMap<V> {
    private final List<ClassEntry<V>> classEntries;
    private final List<MethodEntry<V>> methodEntries;
    private final List<FieldEntry<V>> fieldEntries;
    private final List<ConstructorEntry<V>> constructorEntries;
    final boolean noClassEntries;
    final boolean noMethodEntries;
    final boolean noFieldEntries;
    final boolean noConstructorEntries;

    ReflectionMap(Builder<V> b) {
        this.classEntries = Collections.unmodifiableList(new ArrayList(b.classEntries));
        this.methodEntries = Collections.unmodifiableList(new ArrayList(b.methodEntries));
        this.fieldEntries = Collections.unmodifiableList(new ArrayList(b.fieldEntries));
        this.constructorEntries = Collections.unmodifiableList(new ArrayList(b.constructorEntries));
        this.noClassEntries = this.classEntries.isEmpty();
        this.noMethodEntries = this.methodEntries.isEmpty();
        this.noFieldEntries = this.fieldEntries.isEmpty();
        this.noConstructorEntries = this.constructorEntries.isEmpty();
    }

    public static <V> Builder<V> create(Class<V> c) {
        return new Builder();
    }

    static List<String> splitNames(String key) {
        if (key.indexOf(44) == -1) {
            return Collections.singletonList(key.trim());
        }
        ArrayList<String> l = new ArrayList<String>();
        int m = 0;
        boolean escaped = false;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '(') {
                escaped = true;
                continue;
            }
            if (c == ')') {
                escaped = false;
                continue;
            }
            if (c != ',' || escaped) continue;
            l.add(key.substring(m, i).trim());
            m = i + 1;
        }
        l.add(key.substring(m).trim());
        return l;
    }

    public Optional<V> find(Class<?> c, Class<? extends V> ofType) {
        if (!this.noClassEntries) {
            for (ClassEntry<V> e : this.classEntries) {
                if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.ofNullable(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Class<?> c) {
        return this.find(c, null);
    }

    public List<V> findAll(Class<?> c, Class<? extends V> ofType) {
        return this.appendAll(c, ofType, null);
    }

    public List<V> findAll(Class<?> c) {
        return this.appendAll(c, null, null);
    }

    public List<V> appendAll(Class<?> c, Class<? extends V> ofType, List<V> l) {
        if (l == null) {
            l = AList.of();
        }
        if (!this.noClassEntries) {
            for (ClassEntry<V> e : this.classEntries) {
                if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
                l.add(e.value);
            }
        }
        return l;
    }

    public Optional<V> find(Method m, Class<? extends V> ofType) {
        if (!this.noMethodEntries) {
            for (MethodEntry<V> e : this.methodEntries) {
                if (!e.matches(m) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.ofNullable(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Method m) {
        return this.find(m, null);
    }

    public List<V> findAll(Method m, Class<? extends V> ofType) {
        return this.appendAll(m, ofType, null);
    }

    public List<V> findAll(Method m) {
        return this.appendAll(m, null, null);
    }

    public List<V> appendAll(Method m, Class<? extends V> ofType, List<V> l) {
        if (l == null) {
            l = AList.of();
        }
        if (!this.noMethodEntries) {
            for (MethodEntry<V> e : this.methodEntries) {
                if (!e.matches(m) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
                l.add(e.value);
            }
        }
        return l;
    }

    public Optional<V> find(Field f, Class<? extends V> ofType) {
        if (!this.noFieldEntries) {
            for (FieldEntry<V> e : this.fieldEntries) {
                if (!e.matches(f) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.ofNullable(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Field f) {
        return this.find(f, null);
    }

    public List<V> findAll(Field f, Class<? extends V> ofType) {
        return this.appendAll(f, ofType, null);
    }

    public List<V> findAll(Field f) {
        return this.appendAll(f, null, null);
    }

    public List<V> appendAll(Field f, Class<? extends V> ofType, List<V> l) {
        if (l == null) {
            l = AList.of();
        }
        if (!this.noFieldEntries) {
            for (FieldEntry<V> e : this.fieldEntries) {
                if (!e.matches(f) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
                l.add(e.value);
            }
        }
        return l == null ? new ArrayList(0) : l;
    }

    public Optional<V> find(Constructor<?> c, Class<? extends V> ofType) {
        if (!this.noConstructorEntries) {
            for (ConstructorEntry<V> e : this.constructorEntries) {
                if (!e.matches(c) || ofType != null && !ofType.isInstance(e.value)) continue;
                return Optional.ofNullable(e.value);
            }
        }
        return Optional.empty();
    }

    public Optional<V> find(Constructor<?> c) {
        return this.find(c, null);
    }

    public List<V> findAll(Constructor<?> c, Class<? extends V> ofType) {
        return this.appendAll(c, ofType, null);
    }

    public List<V> findAll(Constructor<?> c) {
        return this.appendAll(c, null, null);
    }

    public List<V> appendAll(Constructor<?> c, Class<? extends V> ofType, List<V> l) {
        if (l == null) {
            l = AList.of();
        }
        if (!this.noConstructorEntries) {
            for (ConstructorEntry<V> e : this.constructorEntries) {
                if (!e.matches(c) || e.value == null || ofType != null && !ofType.isInstance(e.value)) continue;
                l.add(e.value);
            }
        }
        return l;
    }

    static boolean argsMatch(String[] names, Class<?>[] args) {
        if (names == null) {
            return true;
        }
        if (names.length != args.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            String n = names[i];
            Class<?> a = args[i];
            if (StringUtils.isEquals(n, a.getSimpleName()) || StringUtils.isEquals(n, a.getName())) continue;
            return false;
        }
        return true;
    }

    static String simpleClassName(String name) {
        int i = name.indexOf(46);
        if (i == -1) {
            return name;
        }
        return null;
    }

    static boolean classMatches(String simpleName, String fullName, Class<?> c) {
        String cSimple = c.getSimpleName();
        String cFull = c.getName();
        if (StringUtils.isEquals(simpleName, cSimple) || StringUtils.isEquals(fullName, cFull)) {
            return true;
        }
        if ("*".equals(simpleName)) {
            return true;
        }
        if (cFull.indexOf(36) != -1) {
            Package p = c.getPackage();
            if (p != null) {
                cFull = cFull.substring(p.getName().length() + 1);
            }
            if (StringUtils.isEquals(simpleName, cFull)) {
                return true;
            }
            int i = cFull.indexOf(36);
            while (i != -1) {
                if (StringUtils.isEquals(simpleName, cFull = cFull.substring(i + 1))) {
                    return true;
                }
                i = cFull.indexOf(36);
            }
        }
        return false;
    }

    public String toString() {
        return OMap.of(new Object[]{"classEntries", this.classEntries, "methodEntries", this.methodEntries, "fieldEntries", this.fieldEntries, "constructorEntries", this.constructorEntries}).toString();
    }

    static class FieldEntry<V> {
        String simpleClassName;
        String fullClassName;
        String fieldName;
        V value;

        FieldEntry(String name, V value) {
            int i = name.lastIndexOf(46);
            String s1 = name.substring(0, i);
            String s2 = name.substring(i + 1);
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.fieldName = s2;
            this.value = value;
        }

        public boolean matches(Field f) {
            if (f == null) {
                return false;
            }
            Class<?> c = f.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.isEquals(f.getName(), this.fieldName);
        }

        public OMap asMap() {
            return OMap.of(new Object[]{"simpleClassName", this.simpleClassName, "fullClassName", this.fullClassName, "fieldName", this.fieldName, "value", this.value});
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class ConstructorEntry<V> {
        String simpleClassName;
        String fullClassName;
        String[] args;
        V value;

        ConstructorEntry(String name, V value) {
            int i = name.indexOf(40);
            this.args = StringUtils.split(name.substring(i + 1, name.length() - 1));
            name = name.substring(0, i).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(name);
            this.fullClassName = name;
            this.value = value;
        }

        public boolean matches(Constructor<?> m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public OMap asMap() {
            return OMap.of(new Object[]{"simpleClassName", this.simpleClassName, "fullClassName", this.fullClassName, "args", this.args, "value", this.value});
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class MethodEntry<V> {
        String simpleClassName;
        String fullClassName;
        String methodName;
        String[] args;
        V value;

        MethodEntry(String name, V value) {
            int i = name.indexOf(40);
            String[] stringArray = this.args = i == -1 ? null : StringUtils.splitMethodArgs(name.substring(i + 1, name.length() - 1));
            if (this.args != null) {
                for (int j = 0; j < this.args.length; ++j) {
                    int k = this.args[j].indexOf(60);
                    if (k > 0) {
                        this.args[j] = this.args[j].substring(0, k);
                    }
                    if (!this.args[j].endsWith("[]")) continue;
                    int l = 0;
                    while (this.args[j].endsWith("[]")) {
                        ++l;
                        this.args[j] = this.args[j].substring(0, this.args[j].length() - 2);
                    }
                    StringBuilder sb = new StringBuilder(this.args[j].length() + l + 2);
                    for (int m = 0; m < l; ++m) {
                        sb.append('[');
                    }
                    sb.append('L').append(this.args[j]).append(';');
                    this.args[j] = sb.toString();
                }
            }
            name = i == -1 ? name : name.substring(0, i);
            i = name.lastIndexOf(46);
            String s1 = name.substring(0, i).trim();
            String s2 = name.substring(i + 1).trim();
            this.simpleClassName = ReflectionMap.simpleClassName(s1);
            this.fullClassName = s1;
            this.methodName = s2;
            this.value = value;
        }

        public boolean matches(Method m) {
            if (m == null) {
                return false;
            }
            Class<?> c = m.getDeclaringClass();
            return ReflectionMap.classMatches(this.simpleClassName, this.fullClassName, c) && StringUtils.isEquals(m.getName(), this.methodName) && ReflectionMap.argsMatch(this.args, m.getParameterTypes());
        }

        public OMap asMap() {
            return OMap.of(new Object[]{"simpleClassName", this.simpleClassName, "fullClassName", this.fullClassName, "methodName", this.methodName, "args", this.args, "value", this.value});
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    static class ClassEntry<V> {
        final String simpleName;
        final String fullName;
        final V value;

        ClassEntry(String name, V value) {
            this.simpleName = ReflectionMap.simpleClassName(name);
            this.fullName = name;
            this.value = value;
        }

        public boolean matches(Class<?> c) {
            if (c == null) {
                return false;
            }
            return ReflectionMap.classMatches(this.simpleName, this.fullName, c);
        }

        public OMap asMap() {
            return OMap.of(new Object[]{"simpleName", this.simpleName, "fullName", this.fullName, "value", this.value});
        }

        public String toString() {
            return this.asMap().toString();
        }
    }

    public static class Builder<V> {
        List<ClassEntry<V>> classEntries = new ArrayList<ClassEntry<V>>();
        List<MethodEntry<V>> methodEntries = new ArrayList<MethodEntry<V>>();
        List<FieldEntry<V>> fieldEntries = new ArrayList<FieldEntry<V>>();
        List<ConstructorEntry<V>> constructorEntries = new ArrayList<ConstructorEntry<V>>();

        public Builder<V> append(String key, V value) {
            if (StringUtils.isEmpty(key)) {
                throw new RuntimeException("Invalid reflection signature: [" + key + "]");
            }
            try {
                for (String k : ReflectionMap.splitNames(key)) {
                    int i;
                    if (k.endsWith(")")) {
                        i = k.substring(0, k.indexOf(40)).lastIndexOf(46);
                        if (i == -1 || Character.isUpperCase(k.charAt(i + 1))) {
                            this.constructorEntries.add(new ConstructorEntry<V>(k, value));
                            continue;
                        }
                        this.methodEntries.add(new MethodEntry<V>(k, value));
                        continue;
                    }
                    i = k.lastIndexOf(46);
                    if (i == -1) {
                        this.classEntries.add(new ClassEntry<V>(k, value));
                        continue;
                    }
                    if (Character.isUpperCase(k.charAt(i + 1))) {
                        this.classEntries.add(new ClassEntry<V>(k, value));
                        this.fieldEntries.add(new FieldEntry<V>(k, value));
                        continue;
                    }
                    this.methodEntries.add(new MethodEntry<V>(k, value));
                    this.fieldEntries.add(new FieldEntry<V>(k, value));
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Invalid reflection signature: [" + key + "]");
            }
            return this;
        }

        public ReflectionMap<V> build() {
            return new ReflectionMap(this);
        }
    }
}

