/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.http.Header;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.HttpEntityBuilder;
import org.apache.juneau.http.entity.SerializedEntityBuilder;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.NoCloseOutputStream;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;

public class SerializedEntity
extends BasicHttpEntity {
    final Serializer serializer;
    HttpPartSchema schema;

    public static SerializedEntityBuilder<SerializedEntity> create() {
        return new SerializedEntityBuilder<Class<SerializedEntity>>(SerializedEntity.class);
    }

    public SerializedEntity(SerializedEntityBuilder<?> builder) {
        super(builder);
        this.serializer = builder.serializer;
        this.schema = builder.schema;
    }

    public SerializedEntityBuilder<SerializedEntity> copy() {
        return new SerializedEntityBuilder<SerializedEntity>(this);
    }

    public SerializedEntity copyWith(Serializer serializer, HttpPartSchema schema) {
        if (this.serializer == null && serializer != null || this.schema == null && schema != null) {
            HttpEntityBuilder h = this.copy();
            if (serializer != null) {
                ((SerializedEntityBuilder)h).serializer(serializer);
            }
            if (schema != null) {
                ((SerializedEntityBuilder)h).schema(schema);
            }
            return ((SerializedEntityBuilder)h).build();
        }
        return this;
    }

    @Override
    public Header getContentType() {
        Header x = super.getContentType();
        if (x == null && this.serializer != null) {
            x = HttpHeaders.contentType(this.serializer.getPrimaryMediaType());
        }
        return x;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        block27: {
            try {
                os = new NoCloseOutputStream(os);
                Object o = this.contentOrElse(null);
                if (this.serializer == null) {
                    try (OutputStreamWriter w = new OutputStreamWriter(os, IOUtils.UTF8);){
                        w.write(o.toString());
                        break block27;
                    }
                }
                SerializerSession session = this.serializer.createSession().schema(this.schema).build();
                try (Closeable c = session.isWriterSerializer() ? new OutputStreamWriter(os, IOUtils.UTF8) : os;){
                    session.serialize(o, c);
                }
            }
            catch (SerializeException e) {
                throw ThrowableUtils.runtimeException(e, "Serialization error on request body.", new Object[0]);
            }
        }
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public InputStream getContent() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.writeTo(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException e) {
            throw ThrowableUtils.runtimeException(e);
        }
    }
}

