/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.msgpack;

import java.io.IOException;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.msgpack.DataType;
import org.apache.juneau.parser.ParserInputStream;
import org.apache.juneau.parser.ParserPipe;

public final class MsgPackInputStream
extends ParserInputStream {
    private DataType currentDataType;
    private long length;
    private int lastByte;
    private int extType;
    int pos = 0;
    private static final DataType[] TYPES = new DataType[]{DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.MAP, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.ARRAY, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.STRING, DataType.NULL, DataType.INVALID, DataType.BOOLEAN, DataType.BOOLEAN, DataType.BIN, DataType.BIN, DataType.BIN, DataType.EXT, DataType.EXT, DataType.EXT, DataType.FLOAT, DataType.DOUBLE, DataType.INT, DataType.INT, DataType.LONG, DataType.LONG, DataType.INT, DataType.INT, DataType.INT, DataType.LONG, DataType.EXT, DataType.EXT, DataType.EXT, DataType.EXT, DataType.EXT, DataType.STRING, DataType.STRING, DataType.STRING, DataType.ARRAY, DataType.ARRAY, DataType.MAP, DataType.MAP, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT, DataType.INT};

    protected MsgPackInputStream(ParserPipe pipe) throws IOException {
        super(pipe);
    }

    DataType readDataType() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw ThrowableUtils.ioException("Unexpected end of file found at position {0}", this.pos);
        }
        this.currentDataType = TYPES[i];
        switch (this.currentDataType) {
            case NULL: 
            case FLOAT: {
                this.length = 4L;
                break;
            }
            case DOUBLE: {
                this.length = 8L;
                break;
            }
            case BOOLEAN: {
                this.lastByte = i;
                break;
            }
            case INT: {
                this.lastByte = i;
                if (i <= 127) {
                    this.length = 0L;
                    break;
                }
                if (i >= 224) {
                    this.length = -1L;
                    break;
                }
                if (i == 208 || i == 204) {
                    this.length = 1L;
                    break;
                }
                if (i == 209 || i == 205) {
                    this.length = 2L;
                    break;
                }
                if (i == 210) {
                    this.length = 4L;
                    break;
                }
                this.length = 0L;
                break;
            }
            case LONG: {
                if (i == 206) {
                    this.length = 4L;
                    break;
                }
                if (i == 211 || i == 207) {
                    this.length = 8L;
                    break;
                }
                this.length = 0L;
                break;
            }
            case STRING: {
                if (i <= 191) {
                    this.length = i & 0x1F;
                    break;
                }
                if (i == 217) {
                    this.length = this.readUInt1();
                    break;
                }
                if (i == 218) {
                    this.length = this.readUInt2();
                    break;
                }
                this.length = this.readUInt4();
                break;
            }
            case ARRAY: {
                if (i <= 159) {
                    this.length = i & 0xF;
                    break;
                }
                if (i == 220) {
                    this.length = this.readUInt2();
                    break;
                }
                this.length = this.readUInt4();
                break;
            }
            case BIN: {
                if (i == 196) {
                    this.length = this.readUInt1();
                    break;
                }
                if (i == 197) {
                    this.length = this.readUInt2();
                    break;
                }
                this.length = this.readUInt4();
                break;
            }
            case EXT: {
                if (i == 212) {
                    this.length = 1L;
                } else if (i == 213) {
                    this.length = 2L;
                } else if (i == 214) {
                    this.length = 4L;
                } else if (i == 215) {
                    this.length = 8L;
                } else if (i == 216) {
                    this.length = 16L;
                } else if (i == 199) {
                    this.length = this.readUInt1();
                } else if (i == 200) {
                    this.length = this.readUInt2();
                } else if (i == 201) {
                    this.length = this.readUInt4();
                }
                this.extType = this.read();
                break;
            }
            case MAP: {
                if (i <= 143) {
                    this.length = i & 0xF;
                    break;
                }
                if (i == 222) {
                    this.length = this.readUInt2();
                    break;
                }
                this.length = this.readUInt4();
                break;
            }
            default: {
                throw ThrowableUtils.ioException("Invalid flag 0xC1 detected in stream.", new Object[0]);
            }
        }
        return this.currentDataType;
    }

    long readLength() {
        return this.length;
    }

    boolean readBoolean() {
        return this.lastByte == 195;
    }

    String readString() throws IOException {
        return new String(this.readBinary(), IOUtils.UTF8);
    }

    byte[] readBinary() throws IOException {
        byte[] b = new byte[(int)this.length];
        this.read(b);
        return b;
    }

    int readInt() throws IOException {
        if (this.length == 0L) {
            return this.lastByte;
        }
        if (this.length == 1L) {
            return this.read();
        }
        if (this.length == 2L) {
            return this.read() << 8 | this.read();
        }
        int i = this.read();
        i <<= 8;
        i |= this.read();
        i <<= 8;
        i |= this.read();
        i <<= 8;
        return i |= this.read();
    }

    float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    long readLong() throws IOException {
        if (this.length == 4L) {
            return this.readUInt4();
        }
        long l = this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        return l |= (long)this.read();
    }

    int getExtType() {
        return this.extType;
    }

    private int readUInt1() throws IOException {
        return this.read();
    }

    private int readUInt2() throws IOException {
        return this.read() << 8 | this.read();
    }

    private long readUInt4() throws IOException {
        long l = this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        l |= (long)this.read();
        l <<= 8;
        return l |= (long)this.read();
    }
}

