/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public final class HttpResponseProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException {
        RestResponse res = opSession.getResponse();
        HttpResponse r = res.getContent(HttpResponse.class);
        if (r == null) {
            return 0;
        }
        opSession.status(r.getStatusLine());
        HttpEntity e = r.getEntity();
        res.setHeader(e.getContentType());
        res.setHeader(e.getContentEncoding());
        long contentLength = e.getContentLength();
        if (contentLength >= 0L) {
            res.setHeader(HttpHeaders.contentLength(contentLength));
        }
        r.headerIterator().forEachRemaining(x -> res.addHeader((Header)x));
        try (FinishableServletOutputStream os = res.getNegotiatedOutputStream();){
            e.writeTo((OutputStream)((Object)os));
            ((OutputStream)((Object)os)).flush();
        }
        return 1;
    }
}

