/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.function.Consumer;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ThrowableUtils;

public class HtmlClassMeta
extends ExtendedClassMeta {
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender<?> render;

    public HtmlClassMeta(ClassMeta<?> cm, HtmlMetaProvider mp) {
        super(cm);
        Value<Boolean> noTables = Value.empty();
        Value<Boolean> noTableHeaders = Value.empty();
        Value<HtmlFormat> format = Value.empty();
        Value<Object> render = Value.empty();
        Consumer<Html> c = x -> {
            if (x.noTables()) {
                noTables.set(true);
            }
            if (x.noTableHeaders()) {
                noTableHeaders.set(true);
            }
            if (x.format() != HtmlFormat.HTML) {
                format.set(x.format());
            }
            if (x.render() != HtmlRender.class) {
                try {
                    render.set(x.render().newInstance());
                }
                catch (Exception e) {
                    throw ThrowableUtils.runtimeException(e);
                }
            }
        };
        cm.forEachAnnotation(Html.class, x -> true, c);
        this.noTables = noTables.orElse(false);
        this.noTableHeaders = noTableHeaders.orElse(false);
        this.render = render.orElse(null);
        this.format = format.orElse(HtmlFormat.HTML);
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender<?> getRender() {
        return this.render;
    }
}

