/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.HttpExceptionBuilder;

@Response
@StatusCode(value={405})
@Schema(description={"Method Not Allowed"})
public class MethodNotAllowed
extends BasicHttpException {
    private static final long serialVersionUID = 1L;
    public static final int STATUS_CODE = 405;
    public static final String REASON_PHRASE = "Method Not Allowed";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(405).reasonPhrase("Method Not Allowed").build();
    public static final MethodNotAllowed INSTANCE = (MethodNotAllowed)((HttpExceptionBuilder)MethodNotAllowed.create().unmodifiable()).build();

    public static HttpExceptionBuilder<MethodNotAllowed> create() {
        return new HttpExceptionBuilder<Class<MethodNotAllowed>>(MethodNotAllowed.class).statusLine(STATUS_LINE);
    }

    public MethodNotAllowed(HttpExceptionBuilder<?> builder) {
        super(builder);
    }

    public MethodNotAllowed(Throwable cause, String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)((HttpExceptionBuilder)MethodNotAllowed.create().causedBy(cause)).message(msg, args));
    }

    public MethodNotAllowed() {
        this(MethodNotAllowed.create());
    }

    public MethodNotAllowed(String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)MethodNotAllowed.create().message(msg, args));
    }

    public MethodNotAllowed(Throwable cause) {
        this((HttpExceptionBuilder<?>)MethodNotAllowed.create().causedBy(cause));
    }

    public MethodNotAllowed(HttpResponse response) {
        this(MethodNotAllowed.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpExceptionBuilder<MethodNotAllowed> copy() {
        return new HttpExceptionBuilder<MethodNotAllowed>(this);
    }
}

