/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.NameValuePair;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ConfigException;
import org.apache.juneau.Context;
import org.apache.juneau.Enablement;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.DefaultClassList;
import org.apache.juneau.encoders.EncoderSet;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.http.part.PartList;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.ResponseBeanMeta;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserSet;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.HttpRuntimeException;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpInvoker;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestSession;
import org.apache.juneau.rest.annotation.RestDelete;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestOp;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.annotation.RestPut;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.converter.RestConverterList;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.rest.guard.RestGuard;
import org.apache.juneau.rest.guard.RestGuardList;
import org.apache.juneau.rest.guard.RoleBasedRestGuard;
import org.apache.juneau.rest.httppart.NamedAttributeList;
import org.apache.juneau.rest.httppart.ResponsePartMeta;
import org.apache.juneau.rest.logging.RestLogger;
import org.apache.juneau.rest.matcher.ClientVersionMatcher;
import org.apache.juneau.rest.matcher.RestMatcher;
import org.apache.juneau.rest.matcher.RestMatcherList;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.rest.util.UrlPathMatch;
import org.apache.juneau.rest.util.UrlPathMatcher;
import org.apache.juneau.rest.util.UrlPathMatcherList;
import org.apache.juneau.serializer.SerializerSet;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.utils.HashKey;

public class RestOpContext
extends Context
implements Comparable<RestOpContext> {
    private final String httpMethod;
    private final UrlPathMatcher[] pathMatchers;
    private final RestGuard[] guards;
    private final RestMatcher[] requiredMatchers;
    private final RestMatcher[] optionalMatchers;
    private final RestConverter[] converters;
    private final RestContext context;
    private final Method method;
    private final RestOpInvoker methodInvoker;
    private final RestOpInvoker[] preCallMethods;
    private final RestOpInvoker[] postCallMethods;
    private final MethodInfo mi;
    private final BeanContext beanContext;
    private final SerializerSet serializers;
    private final ParserSet parsers;
    private final EncoderSet encoders;
    private final HttpPartSerializer partSerializer;
    private final HttpPartParser partParser;
    private final JsonSchemaGenerator jsonSchemaGenerator;
    private final HeaderList defaultRequestHeaders;
    private final HeaderList defaultResponseHeaders;
    private final PartList defaultRequestQueryData;
    private final PartList defaultRequestFormData;
    private final NamedAttributeList defaultRequestAttributes;
    private final Charset defaultCharset;
    private final long maxInput;
    private final List<MediaType> supportedAcceptTypes;
    private final List<MediaType> supportedContentTypes;
    private final RestLogger callLogger;
    private final Map<Class<?>, ResponseBeanMeta> responseBeanMetas = new ConcurrentHashMap();
    private final Map<Class<?>, ResponsePartMeta> headerPartMetas = new ConcurrentHashMap();
    private final ResponseBeanMeta responseMeta;
    private final int hierarchyDepth;
    private final DebugEnablement debug;

    public static Builder create(Method method, RestContext context) {
        return new Builder(method, context);
    }

    protected RestOpContext(Builder builder) throws ServletException {
        super((Context.Builder)builder);
        try {
            this.context = builder.restContext;
            this.method = builder.restMethod;
            this.debug = builder.debug == null ? this.context.getDebugEnablement() : DebugEnablement.create(this.context.getRootBeanStore()).enable(builder.debug, "*").build();
            this.mi = MethodInfo.of((Method)this.method).accessible();
            Object r = this.context.getResource();
            BeanStore bs = BeanStore.of((BeanStore)this.context.getRootBeanStore(), (Object)r).addBean(RestOpContext.class, (Object)this).addBean(Method.class, (Object)this.method).addBean(AnnotationWorkList.class, (Object)builder.getApplied());
            bs.addBean(BeanStore.class, (Object)bs);
            this.beanContext = (BeanContext)bs.add(BeanContext.class, (Object)builder.getBeanContext().orElse(this.context.getBeanContext()));
            this.encoders = (EncoderSet)bs.add(EncoderSet.class, (Object)builder.getEncoders().orElse(this.context.getEncoders()));
            this.serializers = (SerializerSet)bs.add(SerializerSet.class, (Object)builder.getSerializers().orElse(this.context.getSerializers()));
            this.parsers = (ParserSet)bs.add(ParserSet.class, (Object)builder.getParsers().orElse(this.context.getParsers()));
            this.partSerializer = (HttpPartSerializer)bs.add(HttpPartSerializer.class, (Object)builder.getPartSerializer().orElse(this.context.getPartSerializer()));
            this.partParser = (HttpPartParser)bs.add(HttpPartParser.class, (Object)builder.getPartParser().orElse(this.context.getPartParser()));
            this.jsonSchemaGenerator = (JsonSchemaGenerator)bs.add(JsonSchemaGenerator.class, (Object)builder.getJsonSchemaGenerator().orElse(this.context.getJsonSchemaGenerator()));
            this.converters = (RestConverter[])bs.add(RestConverter[].class, (Object)((RestConverterList)builder.converters().build()).asArray());
            this.guards = (RestGuard[])bs.add(RestGuard[].class, (Object)builder.getGuards().asArray());
            RestMatcherList matchers = builder.getMatchers(this.context);
            this.optionalMatchers = matchers.getOptionalEntries();
            this.requiredMatchers = matchers.getRequiredEntries();
            this.pathMatchers = (UrlPathMatcher[])bs.add(UrlPathMatcher[].class, (Object)builder.getPathMatchers().asArray());
            bs.addBean(UrlPathMatcher.class, this.pathMatchers.length > 0 ? this.pathMatchers[0] : null);
            this.supportedAcceptTypes = CollectionUtils.unmodifiable((List)(builder.produces != null ? builder.produces : this.serializers.getSupportedMediaTypes()));
            this.supportedContentTypes = CollectionUtils.unmodifiable((List)(builder.consumes != null ? builder.consumes : this.parsers.getSupportedMediaTypes()));
            this.defaultRequestHeaders = (HeaderList)builder.defaultRequestHeaders().build();
            this.defaultResponseHeaders = (HeaderList)builder.defaultResponseHeaders().build();
            this.defaultRequestQueryData = (PartList)builder.defaultRequestQueryData().build();
            this.defaultRequestFormData = (PartList)builder.defaultRequestFormData().build();
            this.defaultRequestAttributes = (NamedAttributeList)builder.defaultRequestAttributes().build();
            int _hierarchyDepth = 0;
            for (Class<?> sc = this.method.getDeclaringClass().getSuperclass(); sc != null; sc = sc.getSuperclass()) {
                ++_hierarchyDepth;
            }
            this.hierarchyDepth = _hierarchyDepth;
            String _httpMethod = builder.httpMethod;
            if (_httpMethod == null) {
                _httpMethod = HttpUtils.detectHttpMethod((Method)this.method, (boolean)true, (String)"GET");
            }
            if ("METHOD".equals(_httpMethod)) {
                _httpMethod = "*";
            }
            this.httpMethod = _httpMethod.toUpperCase(Locale.ENGLISH);
            this.defaultCharset = builder.defaultCharset != null ? builder.defaultCharset : this.context.defaultCharset;
            this.maxInput = builder.maxInput != null ? builder.maxInput : this.context.maxInput;
            this.responseMeta = ResponseBeanMeta.create((MethodInfo)this.mi, (AnnotationWorkList)builder.getApplied());
            this.preCallMethods = (RestOpInvoker[])this.context.getPreCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.postCallMethods = (RestOpInvoker[])this.context.getPostCallMethods().stream().map(x -> new RestOpInvoker((Method)x, this.context.findRestOperationArgs((Method)x, bs), this.context.getMethodExecStats((Method)x))).toArray(RestOpInvoker[]::new);
            this.methodInvoker = new RestOpInvoker(this.method, this.context.findRestOperationArgs(this.method, bs), this.context.getMethodExecStats(this.method));
            this.callLogger = this.context.getCallLogger();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public RestOpSession.Builder createSession(RestSession session) throws Exception {
        return RestOpSession.create(this, session).logger(this.callLogger).debug(this.debug.isDebug(this, session.getRequest()));
    }

    public RestRequest createRequest(RestSession session) throws Exception {
        return new RestRequest(this, session);
    }

    public RestResponse createResponse(RestSession session, RestRequest req) throws Exception {
        return new RestResponse(this, session, req);
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public ResponseBeanMeta getResponseBeanMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponseBeanMeta rbm = this.responseBeanMetas.get(c);
        if (rbm == null) {
            rbm = ResponseBeanMeta.create(c, (AnnotationWorkList)AnnotationWorkList.create());
            if (rbm == null) {
                rbm = ResponseBeanMeta.NULL;
            }
            this.responseBeanMetas.put(c, rbm);
        }
        if (rbm == ResponseBeanMeta.NULL) {
            return null;
        }
        return rbm;
    }

    public ResponsePartMeta getResponseHeaderMeta(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        ResponsePartMeta pm = this.headerPartMetas.get(c);
        if (pm == null) {
            Header a = c.getAnnotation(Header.class);
            if (a != null) {
                HttpPartSchema schema = HttpPartSchema.create((Annotation)a);
                HttpPartSerializer serializer = RestOpContext.createPartSerializer(schema.getSerializer(), this.partSerializer);
                pm = new ResponsePartMeta(HttpPartType.HEADER, schema, serializer);
            }
            if (pm == null) {
                pm = ResponsePartMeta.NULL;
            }
            this.headerPartMetas.put(c, pm);
        }
        if (pm == ResponsePartMeta.NULL) {
            return null;
        }
        return pm;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPathPattern() {
        return this.pathMatchers[0].toString();
    }

    public SerializerSet getSerializers() {
        return this.serializers;
    }

    public ParserSet getParsers() {
        return this.parsers;
    }

    public EncoderSet getEncoders() {
        return this.encoders;
    }

    public HttpPartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    public HttpPartParser getPartParser() {
        return this.partParser;
    }

    public JsonSchemaGenerator getJsonSchemaGenerator() {
        return this.jsonSchemaGenerator;
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public HeaderList getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public HeaderList getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    public PartList getDefaultRequestQueryData() {
        return this.defaultRequestQueryData;
    }

    public PartList getDefaultRequestFormData() {
        return this.defaultRequestFormData;
    }

    public NamedAttributeList getDefaultRequestAttributes() {
        return this.defaultRequestAttributes;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public List<MediaType> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public List<MediaType> getSupportedAcceptTypes() {
        return this.supportedAcceptTypes;
    }

    public ResponseBeanMeta getResponseMeta() {
        return this.responseMeta;
    }

    protected int match(RestSession session) {
        UrlPathMatch pm = this.matchPattern(session);
        if (pm == null) {
            return 0;
        }
        if (this.requiredMatchers.length == 0 && this.optionalMatchers.length == 0) {
            session.urlPathMatch(pm);
            return 2;
        }
        try {
            HttpServletRequest req = session.getRequest();
            for (RestMatcher m : this.requiredMatchers) {
                if (m.matches(req)) continue;
                return 1;
            }
            if (this.optionalMatchers.length > 0) {
                boolean matches = false;
                for (RestMatcher m : this.optionalMatchers) {
                    matches |= m.matches(req);
                }
                if (!matches) {
                    return 1;
                }
            }
            session.urlPathMatch(pm);
            return 2;
        }
        catch (Exception e) {
            throw new InternalServerError((Throwable)e);
        }
    }

    RestOpInvoker getMethodInvoker() {
        return this.methodInvoker;
    }

    RestGuard[] getGuards() {
        return this.guards;
    }

    RestConverter[] getConverters() {
        return this.converters;
    }

    RestOpInvoker[] getPreCallMethods() {
        return this.preCallMethods;
    }

    RestOpInvoker[] getPostCallMethods() {
        return this.postCallMethods;
    }

    public Context.Builder copy() {
        throw ThrowableUtils.unsupportedOperationException((String)"Method not implemented.", (Object[])new Object[0]);
    }

    @Override
    public int compareTo(RestOpContext o) {
        int c;
        int i;
        for (i = 0; i < Math.min(this.pathMatchers.length, o.pathMatchers.length); ++i) {
            c = this.pathMatchers[i].compareTo(o.pathMatchers[i]);
            if (c == 0) continue;
            return c;
        }
        c = ObjectUtils.compare((int)o.hierarchyDepth, (int)this.hierarchyDepth);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.requiredMatchers.length, (int)this.requiredMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.optionalMatchers.length, (int)this.optionalMatchers.length);
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)o.guards.length, (int)this.guards.length);
        if (c != 0) {
            return c;
        }
        c = StringUtils.compare((String)this.method.getName(), (String)o.method.getName());
        if (c != 0) {
            return c;
        }
        c = ObjectUtils.compare((int)this.method.getParameterCount(), (int)o.method.getParameterCount());
        if (c != 0) {
            return c;
        }
        for (i = 0; i < this.method.getParameterCount(); ++i) {
            c = StringUtils.compare((String)this.method.getParameterTypes()[i].getName(), (String)o.method.getParameterTypes()[i].getName());
            if (c == 0) continue;
            return c;
        }
        c = StringUtils.compare((String)this.method.getReturnType().getName(), (String)o.method.getReturnType().getName());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof RestOpContext && ObjectUtils.eq((Object)this, (Object)((RestOpContext)o), (x, y) -> x.method.equals(y.method));
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("defaultRequestFormData", (Object)this.defaultRequestFormData).append("defaultRequestHeaders", (Object)this.defaultRequestHeaders).append("defaultRequestQueryData", (Object)this.defaultRequestQueryData).append("httpMethod", (Object)this.httpMethod);
    }

    private static HttpPartSerializer createPartSerializer(Class<? extends HttpPartSerializer> c, HttpPartSerializer _default) {
        return (HttpPartSerializer)BeanCreator.of(HttpPartSerializer.class).type(c).orElse((Object)_default);
    }

    private UrlPathMatch matchPattern(RestSession call) {
        UrlPathMatch pm = null;
        for (UrlPathMatcher pp : this.pathMatchers) {
            if (pm != null) continue;
            pm = pp.match(call.getUrlPath());
        }
        return pm;
    }

    @FluentSetters
    public static class Builder
    extends Context.Builder {
        RestContext restContext;
        RestContext.Builder parent;
        Method restMethod;
        String httpMethod;
        String clientVersion;
        Enablement debug;
        List<String> path;
        private RestConverterList.Builder converters;
        private BeanContext.Builder beanContext;
        private RestGuardList.Builder guards;
        private EncoderSet.Builder encoders;
        private SerializerSet.Builder serializers;
        private ParserSet.Builder parsers;
        private HttpPartSerializer.Creator partSerializer;
        private HttpPartParser.Creator partParser;
        private RestMatcherList.Builder matchers;
        private JsonSchemaGenerator.Builder jsonSchemaGenerator;
        PartList.Builder defaultRequestFormData;
        PartList.Builder defaultRequestQueryData;
        NamedAttributeList.Builder defaultRequestAttributes;
        HeaderList.Builder defaultRequestHeaders;
        HeaderList.Builder defaultResponseHeaders;
        RestMatcherList.Builder restMatchers;
        List<MediaType> produces;
        List<MediaType> consumes;
        Set<String> roleGuard;
        Set<String> rolesDeclared;
        boolean dotAll;
        Charset defaultCharset;
        Long maxInput;
        private BeanStore beanStore;

        public Builder copy() {
            throw new NoSuchMethodError("Not implemented.");
        }

        public RestOpContext build() {
            try {
                return (RestOpContext)this.beanStore.createBean(RestOpContext.class).type(this.getType().orElse(this.getDefaultImplClass())).builder(Builder.class, (Object)this).run();
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }

        protected Class<? extends RestOpContext> getDefaultImplClass() {
            return RestOpContext.class;
        }

        Builder(Method method, RestContext context) {
            this.restContext = context;
            this.parent = context.builder;
            this.restMethod = method;
            this.beanStore = BeanStore.of((BeanStore)context.getRootBeanStore(), context.builder.resource().get()).addBean(Method.class, (Object)method);
            MethodInfo mi = MethodInfo.of(context.getResourceClass(), (Method)method);
            try {
                VarResolver vr = context.getVarResolver();
                VarResolverSession vrs = vr.createSession();
                AnnotationWorkList work = AnnotationWorkList.of((VarResolverSession)vrs, (AnnotationList)mi.getAnnotationList(Context.CONTEXT_APPLY_FILTER));
                this.apply(work);
                if (context.builder.beanContext().canApply(work)) {
                    this.beanContext().apply(work);
                }
                if (context.builder.serializers().canApply(work)) {
                    this.serializers().apply(work);
                }
                if (context.builder.parsers().canApply(work)) {
                    this.parsers().apply(work);
                }
                if (context.builder.partSerializer().canApply(work)) {
                    this.partSerializer().apply(work);
                }
                if (context.builder.partParser().canApply(work)) {
                    this.partParser().apply(work);
                }
                if (context.builder.jsonSchemaGenerator().canApply(work)) {
                    this.jsonSchemaGenerator().apply(work);
                }
                this.processParameterAnnotations();
            }
            catch (Exception e) {
                throw HttpRuntimeException.toHttpException(e, InternalServerError.class);
            }
        }

        public final Supplier<?> resource() {
            return this.restContext.builder.resource();
        }

        public final DefaultClassList defaultClasses() {
            return this.restContext.builder.defaultClasses();
        }

        public final BeanStore beanStore() {
            return this.beanStore;
        }

        public final BeanContext.Builder beanContext() {
            if (this.beanContext == null) {
                this.beanContext = this.createBeanContext(this.beanStore(), this.parent, this.resource());
            }
            return this.beanContext;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            operation.accept(this.beanContext());
            return this;
        }

        protected BeanContext.Builder createBeanContext(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.beanContext().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(BeanContext.Builder.class, v.get()).createMethodFinder(BeanContext.Builder.class, resource).find("createBeanContext", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(BeanContext.Builder.class, v.get()).createMethodFinder(BeanContext.class, resource).find("createBeanContext", new Class[]{Method.class}).run(x -> ((BeanContext.Builder)v.get()).impl((Context)x));
            return (BeanContext.Builder)v.get();
        }

        final Optional<BeanContext> getBeanContext() {
            return CollectionUtils.optional((Object)this.beanContext).map(x -> x.build());
        }

        public final EncoderSet.Builder encoders() {
            if (this.encoders == null) {
                this.encoders = this.createEncoders(this.beanStore(), this.parent, this.resource());
            }
            return this.encoders;
        }

        public final Builder encoders(Consumer<EncoderSet.Builder> operation) {
            operation.accept(this.encoders());
            return this;
        }

        protected EncoderSet.Builder createEncoders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.encoders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(EncoderSet.Builder.class, v.get()).createMethodFinder(EncoderSet.Builder.class, resource).find("createEncoders", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(EncoderSet.Builder.class, v.get()).createMethodFinder(EncoderSet.class, resource).find("createEncoders", new Class[]{Method.class}).run(x -> ((EncoderSet.Builder)v.get()).impl(x));
            return (EncoderSet.Builder)v.get();
        }

        final Optional<EncoderSet> getEncoders() {
            return CollectionUtils.optional((Object)this.encoders).map(x -> (EncoderSet)x.build());
        }

        public final SerializerSet.Builder serializers() {
            if (this.serializers == null) {
                this.serializers = this.createSerializers(this.beanStore(), this.parent, this.resource());
            }
            return this.serializers;
        }

        public final Builder serializers(Consumer<SerializerSet.Builder> operation) {
            operation.accept(this.serializers());
            return this;
        }

        protected SerializerSet.Builder createSerializers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.serializers().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(SerializerSet.Builder.class, v.get()).createMethodFinder(SerializerSet.Builder.class, resource).find("createSerializers", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(SerializerSet.Builder.class, v.get()).createMethodFinder(SerializerSet.class, resource).find("createSerializers", new Class[]{Method.class}).run(x -> ((SerializerSet.Builder)v.get()).impl(x));
            return (SerializerSet.Builder)v.get();
        }

        final Optional<SerializerSet> getSerializers() {
            return CollectionUtils.optional((Object)this.serializers).map(x -> (SerializerSet)x.build());
        }

        public final ParserSet.Builder parsers() {
            if (this.parsers == null) {
                this.parsers = this.createParsers(this.beanStore(), this.parent, this.resource());
            }
            return this.parsers;
        }

        public final Builder parsers(Consumer<ParserSet.Builder> operation) {
            operation.accept(this.parsers());
            return this;
        }

        protected ParserSet.Builder createParsers(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.parsers().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(ParserSet.Builder.class, v.get()).createMethodFinder(ParserSet.Builder.class, resource).find("createParsers", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(ParserSet.Builder.class, v.get()).createMethodFinder(ParserSet.class, resource).find("createParsers", new Class[]{Method.class}).run(x -> ((ParserSet.Builder)v.get()).impl(x));
            return (ParserSet.Builder)v.get();
        }

        final Optional<ParserSet> getParsers() {
            return CollectionUtils.optional((Object)this.parsers).map(x -> (ParserSet)x.build());
        }

        public final HttpPartSerializer.Creator partSerializer() {
            if (this.partSerializer == null) {
                this.partSerializer = this.createPartSerializer(this.beanStore(), this.parent, this.resource());
            }
            return this.partSerializer;
        }

        public final Builder partSerializer(Consumer<HttpPartSerializer.Creator> operation) {
            operation.accept(this.partSerializer());
            return this;
        }

        protected HttpPartSerializer.Creator createPartSerializer(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.partSerializer().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartSerializer.Creator.class, v.get()).createMethodFinder(HttpPartSerializer.Creator.class, resource).find("createPartSerializer", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartSerializer.Creator.class, v.get()).createMethodFinder(HttpPartSerializer.class, resource).find("createPartSerializer", new Class[]{Method.class}).run(x -> ((HttpPartSerializer.Creator)v.get()).impl(x));
            return (HttpPartSerializer.Creator)v.get();
        }

        final Optional<HttpPartSerializer> getPartSerializer() {
            return CollectionUtils.optional((Object)this.partSerializer).map(x -> (HttpPartSerializer)x.create());
        }

        public final HttpPartParser.Creator partParser() {
            if (this.partParser == null) {
                this.partParser = this.createPartParser(this.beanStore(), this.parent, this.resource());
            }
            return this.partParser;
        }

        public final Builder partParser(Consumer<HttpPartParser.Creator> operation) {
            operation.accept(this.partParser());
            return this;
        }

        protected HttpPartParser.Creator createPartParser(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.partParser().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartParser.Creator.class, v.get()).createMethodFinder(HttpPartParser.Creator.class, resource).find("createPartParser", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(HttpPartParser.Creator.class, v.get()).createMethodFinder(HttpPartParser.class, resource).find("createPartParser", new Class[]{Method.class}).run(x -> ((HttpPartParser.Creator)v.get()).impl(x));
            return (HttpPartParser.Creator)v.get();
        }

        final Optional<HttpPartParser> getPartParser() {
            return CollectionUtils.optional((Object)this.partParser).map(x -> (HttpPartParser)x.create());
        }

        public final JsonSchemaGenerator.Builder jsonSchemaGenerator() {
            if (this.jsonSchemaGenerator == null) {
                this.jsonSchemaGenerator = this.createJsonSchemaGenerator(this.beanStore(), this.parent, this.resource());
            }
            return this.jsonSchemaGenerator;
        }

        public final Builder jsonSchemaGenerator(Consumer<JsonSchemaGenerator.Builder> operation) {
            operation.accept(this.jsonSchemaGenerator());
            return this;
        }

        protected JsonSchemaGenerator.Builder createJsonSchemaGenerator(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.jsonSchemaGenerator().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(JsonSchemaGenerator.Builder.class, v.get()).createMethodFinder(JsonSchemaGenerator.Builder.class, resource).find("createJsonSchemaGenerator", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(JsonSchemaGenerator.Builder.class, v.get()).createMethodFinder(JsonSchemaGenerator.class, resource).find("createJsonSchemaGenerator", new Class[]{Method.class}).run(x -> ((JsonSchemaGenerator.Builder)v.get()).impl((Context)x));
            return (JsonSchemaGenerator.Builder)v.get();
        }

        final Optional<JsonSchemaGenerator> getJsonSchemaGenerator() {
            return CollectionUtils.optional((Object)this.jsonSchemaGenerator).map(x -> x.build());
        }

        public final RestConverterList.Builder converters() {
            if (this.converters == null) {
                this.converters = this.createConverters(this.beanStore(), this.resource());
            }
            return this.converters;
        }

        public final Builder converters(Consumer<RestConverterList.Builder> operation) {
            operation.accept(this.converters());
            return this;
        }

        protected RestConverterList.Builder createConverters(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestConverterList.create(beanStore)));
            this.defaultClasses().get(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestConverterList.class).ifPresent(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestConverterList.Builder.class).addBean(RestConverterList.Builder.class, v.get()).find("createConverters", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestConverterList.class).addBean(RestConverterList.Builder.class, v.get()).find("createConverters", new Class[0]).run(x -> ((RestConverterList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestConverterList.Builder)((Object)v.get());
        }

        public final RestGuardList.Builder guards() {
            if (this.guards == null) {
                this.guards = this.createGuards(this.beanStore(), this.resource());
            }
            return this.guards;
        }

        public final Builder guards(Consumer<RestGuardList.Builder> operation) {
            operation.accept(this.guards());
            return this;
        }

        protected RestGuardList.Builder createGuards(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestGuardList.create(beanStore)));
            this.defaultClasses().get(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestGuardList.class).ifPresent(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestGuardList.Builder.class).addBean(RestGuardList.Builder.class, v.get()).find("createGuards", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestGuardList.class).addBean(RestGuardList.Builder.class, v.get()).find("createGuards", new Class[0]).run(x -> ((RestGuardList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestGuardList.Builder)((Object)v.get());
        }

        final RestGuardList getGuards() {
            RestGuardList.Builder b = this.guards();
            Set roleGuard = CollectionUtils.optional(this.roleGuard).orElseGet(() -> CollectionUtils.set((Object[])new String[0]));
            for (String rg : roleGuard) {
                try {
                    b.append(new RoleBasedRestGuard(this.rolesDeclared, rg));
                }
                catch (java.text.ParseException e1) {
                    throw ThrowableUtils.runtimeException((Throwable)e1);
                }
            }
            return (RestGuardList)this.guards.build();
        }

        public final RestMatcherList.Builder matchers() {
            if (this.matchers == null) {
                this.matchers = this.createMatchers(this.beanStore(), this.resource());
            }
            return this.matchers;
        }

        public final Builder matchers(Consumer<RestMatcherList.Builder> operation) {
            operation.accept(this.matchers());
            return this;
        }

        protected RestMatcherList.Builder createMatchers(BeanStore beanStore, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)RestMatcherList.create(beanStore)));
            this.defaultClasses().get(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).type((Class)x));
            beanStore.getBean(RestMatcherList.class).ifPresent(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).impl(x));
            beanStore.createMethodFinder(RestMatcherList.Builder.class).addBean(RestMatcherList.Builder.class, v.get()).find("createMatchers", new Class[0]).run(x -> v.set((Object)x));
            beanStore.createMethodFinder(RestMatcherList.class).addBean(RestMatcherList.Builder.class, v.get()).find("createMatchers", new Class[0]).run(x -> ((RestMatcherList.Builder)((Object)((Object)v.get()))).impl(x));
            return (RestMatcherList.Builder)((Object)v.get());
        }

        final RestMatcherList getMatchers(RestContext restContext) {
            RestMatcherList.Builder b = this.matchers();
            if (this.clientVersion != null) {
                b.append(new ClientVersionMatcher(restContext.getClientVersionHeader(), MethodInfo.of((Method)this.restMethod)));
            }
            return (RestMatcherList)b.build();
        }

        protected UrlPathMatcherList getPathMatchers() {
            Value v = Value.of((Object)UrlPathMatcherList.create());
            if (this.path != null) {
                for (String p : this.path) {
                    if (this.dotAll && !p.endsWith("/*")) {
                        p = p + "/*";
                    }
                    ((UrlPathMatcherList)v.get()).add(UrlPathMatcher.of(p));
                }
            }
            if (((UrlPathMatcherList)v.get()).isEmpty()) {
                String p;
                MethodInfo mi = MethodInfo.of((Method)this.restMethod);
                p = null;
                String httpMethod = null;
                if (mi.hasAnnotation(RestGet.class)) {
                    httpMethod = "get";
                } else if (mi.hasAnnotation(RestPut.class)) {
                    httpMethod = "put";
                } else if (mi.hasAnnotation(RestPost.class)) {
                    httpMethod = "post";
                } else if (mi.hasAnnotation(RestDelete.class)) {
                    httpMethod = "delete";
                } else if (mi.hasAnnotation(RestOp.class)) {
                    Value _httpMethod = Value.empty();
                    mi.forEachAnnotation(RestOp.class, x -> StringUtils.isNotEmpty((String)x.method()), x -> _httpMethod.set((Object)x.method()));
                    httpMethod = (String)_httpMethod.orElse(null);
                }
                p = HttpUtils.detectHttpPath((Method)this.restMethod, (String)httpMethod);
                if (this.dotAll && !p.endsWith("/*")) {
                    p = p + "/*";
                }
                ((UrlPathMatcherList)v.get()).add(UrlPathMatcher.of(p));
            }
            this.beanStore.createMethodFinder(UrlPathMatcherList.class, this.resource().get()).addBean(UrlPathMatcherList.class, v.get()).find("createPathMatchers", new Class[]{Method.class}).run(x -> v.set(x));
            return (UrlPathMatcherList)v.get();
        }

        public Builder dotAll() {
            this.dotAll = true;
            return this;
        }

        public final HeaderList.Builder defaultRequestHeaders() {
            if (this.defaultRequestHeaders == null) {
                this.defaultRequestHeaders = this.createDefaultRequestHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestHeaders;
        }

        public final Builder defaultRequestHeaders(Consumer<HeaderList.Builder> operation) {
            operation.accept(this.defaultRequestHeaders());
            return this;
        }

        protected HeaderList.Builder createDefaultRequestHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.defaultRequestHeaders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.Builder.class, v.get()).createMethodFinder(HeaderList.Builder.class, resource).find("createDefaultRequestHeaders", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.Builder.class, v.get()).createMethodFinder(HeaderList.class, resource).find("createDefaultRequestHeaders", new Class[]{Method.class}).run(x -> ((HeaderList.Builder)v.get()).impl(x));
            return (HeaderList.Builder)v.get();
        }

        public final HeaderList.Builder defaultResponseHeaders() {
            if (this.defaultResponseHeaders == null) {
                this.defaultResponseHeaders = this.createDefaultResponseHeaders(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultResponseHeaders;
        }

        public final Builder defaultResponseHeaders(Consumer<HeaderList.Builder> operation) {
            operation.accept(this.defaultResponseHeaders());
            return this;
        }

        protected HeaderList.Builder createDefaultResponseHeaders(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)parent.defaultResponseHeaders().copy());
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.Builder.class, v.get()).createMethodFinder(HeaderList.Builder.class, resource).find("createDefaultResponseHeaders", new Class[]{Method.class}).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(HeaderList.Builder.class, v.get()).createMethodFinder(HeaderList.class, resource).find("createDefaultResponseHeaders", new Class[]{Method.class}).run(x -> ((HeaderList.Builder)v.get()).impl(x));
            return (HeaderList.Builder)v.get();
        }

        public final NamedAttributeList.Builder defaultRequestAttributes() {
            if (this.defaultRequestAttributes == null) {
                this.defaultRequestAttributes = this.createDefaultRequestAttributes(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestAttributes;
        }

        public final Builder defaultRequestAttributes(Consumer<NamedAttributeList.Builder> operation) {
            operation.accept(this.defaultRequestAttributes());
            return this;
        }

        protected NamedAttributeList.Builder createDefaultRequestAttributes(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)((Object)parent.defaultRequestAttributes().copy()));
            BeanStore.of((BeanStore)beanStore, resource).addBean(NamedAttributeList.Builder.class, v.get()).createMethodFinder(NamedAttributeList.Builder.class, resource).find("createDefaultRequestAttributes", new Class[]{Method.class}).run(x -> v.set((Object)x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(NamedAttributeList.Builder.class, v.get()).createMethodFinder(NamedAttributeList.class, resource).find("createDefaultRequestAttributes", new Class[]{Method.class}).run(x -> ((NamedAttributeList.Builder)((Object)((Object)v.get()))).impl(x));
            return (NamedAttributeList.Builder)((Object)v.get());
        }

        public final PartList.Builder defaultRequestQueryData() {
            if (this.defaultRequestQueryData == null) {
                this.defaultRequestQueryData = this.createDefaultRequestQueryData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestQueryData;
        }

        public final Builder defaultRequestQueryData(Consumer<PartList.Builder> operation) {
            operation.accept(this.defaultRequestQueryData());
            return this;
        }

        protected PartList.Builder createDefaultRequestQueryData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)PartList.create());
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.Builder.class, v.get()).createMethodFinder(PartList.Builder.class, resource).find("createDefaultRequestQueryData", new Class[]{Method.class}).thenFind("createDefaultRequestQueryData", new Class[0]).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.Builder.class, v.get()).createMethodFinder(PartList.class, resource).find("createDefaultRequestQueryData", new Class[]{Method.class}).thenFind("createDefaultRequestQueryData", new Class[0]).run(x -> ((PartList.Builder)v.get()).impl(x));
            return (PartList.Builder)v.get();
        }

        public final PartList.Builder defaultRequestFormData() {
            if (this.defaultRequestFormData == null) {
                this.defaultRequestFormData = this.createDefaultRequestFormData(this.beanStore(), this.parent, this.resource());
            }
            return this.defaultRequestFormData;
        }

        public final Builder defaultRequestFormData(Consumer<PartList.Builder> operation) {
            operation.accept(this.defaultRequestFormData());
            return this;
        }

        protected PartList.Builder createDefaultRequestFormData(BeanStore beanStore, RestContext.Builder parent, Supplier<?> resource) {
            Value v = Value.of((Object)PartList.create());
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.Builder.class, v.get()).createMethodFinder(PartList.Builder.class, resource).find("createDefaultRequestFormData", new Class[]{Method.class}).thenFind("createDefaultRequestFormData", new Class[0]).run(x -> v.set(x));
            BeanStore.of((BeanStore)beanStore, resource).addBean(PartList.Builder.class, v.get()).createMethodFinder(PartList.class, resource).find("createDefaultRequestFormData", new Class[]{Method.class}).thenFind("createDefaultRequestFormData", new Class[0]).run(x -> ((PartList.Builder)v.get()).impl(x));
            return (PartList.Builder)v.get();
        }

        protected void processParameterAnnotations() {
            for (Annotation[] aa : this.restMethod.getParameterAnnotations()) {
                String def = null;
                for (Annotation a : aa) {
                    if (!(a instanceof Schema)) continue;
                    Schema s = (Schema)a;
                    def = this.joinnlFirstNonEmptyArray(s._default(), s.df());
                }
                for (Annotation a : aa) {
                    Header h;
                    if (a instanceof Header) {
                        h = (Header)a;
                        if (def != null) {
                            try {
                                this.defaultRequestHeaders().set((org.apache.http.Header)HttpHeaders.basicHeader((String)StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value()}), (Object)RestUtils.parseAnything(def)));
                            }
                            catch (ParseException e) {
                                throw new ConfigException((Throwable)e, "Malformed @Header annotation", new Object[0]);
                            }
                        }
                    }
                    if (a instanceof Query) {
                        h = (Query)a;
                        if (def != null) {
                            try {
                                this.defaultRequestQueryData().setDefault((NameValuePair)HttpParts.basicPart((String)StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value()}), (Object)RestUtils.parseAnything(def)));
                            }
                            catch (ParseException e) {
                                throw new ConfigException((Throwable)e, "Malformed @Query annotation", new Object[0]);
                            }
                        }
                    }
                    if (!(a instanceof FormData)) continue;
                    h = (FormData)a;
                    if (def == null) continue;
                    try {
                        this.defaultRequestFormData().setDefault((NameValuePair)HttpParts.basicPart((String)StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value()}), (Object)RestUtils.parseAnything(def)));
                    }
                    catch (ParseException e) {
                        throw new ConfigException((Throwable)e, "Malformed @FormData annotation", new Object[0]);
                    }
                }
            }
        }

        public Builder beanStore(BeanStore beanStore) {
            this.beanStore = beanStore;
            return this;
        }

        @FluentSetter
        public Builder clientVersion(String value) {
            this.clientVersion = value;
            return this;
        }

        @FluentSetter
        public Builder debug(Enablement value) {
            this.debug = value;
            return this;
        }

        @FluentSetter
        public Builder defaultCharset(Charset value) {
            this.defaultCharset = value;
            return this;
        }

        @FluentSetter
        public Builder httpMethod(String value) {
            this.httpMethod = value;
            return this;
        }

        @FluentSetter
        public Builder maxInput(String value) {
            this.maxInput = StringUtils.parseLongWithSuffix((String)value);
            return this;
        }

        @FluentSetter
        public Builder path(String ... values) {
            this.path = CollectionUtils.prependAll(this.path, (Object[])values);
            return this;
        }

        @FluentSetter
        public Builder produces(MediaType ... values) {
            this.produces = CollectionUtils.addAll(this.produces, (Object[])values);
            return this;
        }

        @FluentSetter
        public Builder rolesDeclared(String ... values) {
            this.rolesDeclared = CollectionUtils.addAll(this.rolesDeclared, (Object[])values);
            return this;
        }

        @FluentSetter
        public Builder roleGuard(String value) {
            if (this.roleGuard == null) {
                this.roleGuard = CollectionUtils.set((Object[])new String[]{value});
            } else {
                this.roleGuard.add(value);
            }
            return this;
        }

        @FluentSetter
        public Builder consumes(MediaType ... values) {
            this.consumes = CollectionUtils.addAll(this.consumes, (Object[])values);
            return this;
        }

        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        public Builder debug() {
            super.debug();
            return this;
        }

        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        private String joinnlFirstNonEmptyArray(String[] ... s) {
            for (Object[] objectArray : s) {
                if (objectArray.length <= 0) continue;
                return StringUtils.joinnl((Object[])objectArray);
            }
            return null;
        }
    }

    public static final class Void
    extends RestOpContext {
        private Void(Builder builder) throws Exception {
            super(builder);
        }
    }
}

