/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.widget;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlSerializerSession;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringBuilderWriter;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.widget.Widget;

public abstract class MenuItemWidget
extends Widget {
    @Override
    public String getScript(RestRequest req, RestResponse res) {
        return this.loadScript(req, "scripts/MenuItemWidget.js");
    }

    public String getBeforeShowScript(RestRequest req, RestResponse res) {
        return null;
    }

    public String getAfterShowScript(RestRequest req, RestResponse res) {
        return null;
    }

    @Override
    public String getStyle(RestRequest req, RestResponse res) {
        return this.loadStyle(req, "styles/MenuItemWidget.css");
    }

    @Override
    public String getHtml(RestRequest req, RestResponse res) {
        StringBuilder sb;
        block34: {
            sb = new StringBuilder();
            Integer id = null;
            String pre = StringUtils.nullIfEmpty((String)this.getBeforeShowScript(req, res));
            String post = StringUtils.nullIfEmpty((String)this.getAfterShowScript(req, res));
            sb.append("\n<div class='menu-item'>");
            if (pre != null || post != null) {
                id = this.getId(req);
                sb.append("\n\t<script>");
                if (pre != null) {
                    sb.append("\n\t\tfunction onPreShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                if (post != null) {
                    sb.append("\n\t\tfunction onPostShow" + id + "() {");
                    sb.append("\n").append(pre);
                    sb.append("\n\t\t}");
                }
                sb.append("\n\t</script>");
            }
            String onclick = (pre == null ? "" : "onPreShow" + id + "();") + "menuClick(this);" + (post == null ? "" : "onPostShow" + id + "();");
            sb.append("\n\t<a onclick='" + onclick + "'>" + this.getLabel(req, res) + "</a>\n<div class='popup-content'>");
            Object o = this.getContent(req, res);
            if (o instanceof Reader) {
                try (Reader r = (Reader)o;
                     StringBuilderWriter w = new StringBuilderWriter(sb);){
                    IOUtils.pipe((Reader)r, (Writer)w);
                    break block34;
                }
                catch (IOException e) {
                    throw ThrowableUtils.runtimeException((Throwable)e);
                }
            }
            if (o instanceof CharSequence) {
                sb.append((CharSequence)o);
            } else {
                HtmlSerializerSession session = HtmlSerializer.DEFAULT.createSession().properties(req.getAttributes().asMap()).debug(req.isDebug() ? Boolean.valueOf(true) : null).uriContext(req.getUriContext()).useWhitespace(req.isPlainText() ? Boolean.valueOf(true) : null).resolver(req.getVarResolverSession()).build();
                session.indent = 2;
                try {
                    session.serialize(o, (Object)sb);
                }
                catch (Exception e) {
                    throw ThrowableUtils.runtimeException((Throwable)e);
                }
            }
        }
        sb.append("\n\t</div>\n</div>");
        return sb.toString();
    }

    private Integer getId(RestRequest req) {
        Integer id = req.getAttribute("LastMenuItemId").as(Integer.class).orElse(0) + 1;
        req.setAttribute("LastMenuItemId", id);
        return id;
    }

    public abstract String getLabel(RestRequest var1, RestResponse var2);

    public abstract Object getContent(RestRequest var1, RestResponse var2);
}

