/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Supplier;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.resource.ByteArrayResource;
import org.apache.juneau.http.resource.FileResource;
import org.apache.juneau.http.resource.ReaderResource;
import org.apache.juneau.http.resource.StreamResource;
import org.apache.juneau.http.resource.StringResource;

public class HttpResources {
    public static final ByteArrayResource byteArrayResource(byte[] content) {
        return new ByteArrayResource().setContent(content);
    }

    public static final ByteArrayResource byteArrayResource(byte[] content, ContentType contentType) {
        return new ByteArrayResource().setContent(content).setContentType(contentType);
    }

    public static final ByteArrayResource byteArrayResource(Supplier<byte[]> content) {
        return new ByteArrayResource().setContent((Supplier)content);
    }

    public static final ByteArrayResource byteArrayResource(Supplier<byte[]> content, ContentType contentType) {
        return ((ByteArrayResource)new ByteArrayResource().setContent((Supplier)content)).setContentType(contentType);
    }

    public static final FileResource fileResource(File content) {
        return new FileResource().setContent(content);
    }

    public static final FileResource fileResource(File content, ContentType contentType) {
        return new FileResource().setContent(content).setContentType(contentType);
    }

    public static final ReaderResource readerResource(Reader content) {
        return new ReaderResource().setContent(content);
    }

    public static final ReaderResource readerResource(Reader content, ContentType contentType) {
        return new ReaderResource().setContent(content).setContentType(contentType);
    }

    public static final StreamResource streamResource(InputStream content) {
        return new StreamResource().setContent(content);
    }

    public static final StreamResource streamResource(InputStream content, long length, ContentType contentType) {
        return new StreamResource().setContent(content).setContentLength(length).setContentType(contentType);
    }

    public static final StringResource stringResource(String content) {
        return new StringResource().setContent(content);
    }

    public static final StringResource stringResource(String content, ContentType contentType) {
        return new StringResource().setContent(content).setContentType(contentType);
    }

    public static final StringResource stringResource(Supplier<String> content) {
        return new StringResource().setContent((Supplier)content);
    }

    public static final StringResource stringResource(Supplier<String> content, ContentType contentType) {
        return ((StringResource)new StringResource().setContent((Supplier)content)).setContentType(contentType);
    }
}

