/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;

public enum TypeCategory {
    BEAN,
    MAP,
    COLLECTION,
    ARRAY,
    BOOLEAN,
    NUMBER,
    STRING,
    ENUM,
    OTHER,
    ANY;


    public static Set<TypeCategory> parse(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet set = CollectionUtils.set((Object[])new TypeCategory[0]);
        StringUtils.split((String)s, x -> set.add(TypeCategory.valueOf(x.toUpperCase())));
        return set;
    }

    public static TypeCategory[] parseArray(String s) {
        if (s == null || s.isEmpty()) {
            return new TypeCategory[0];
        }
        List list = CollectionUtils.list((Object[])new TypeCategory[0]);
        StringUtils.split((String)s, x -> list.add(TypeCategory.valueOf(x.toUpperCase())));
        return list.toArray(new TypeCategory[list.size()]);
    }
}

