/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.Graph;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareGraphConstructor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;

public class MinTrafficGraphConstructor
implements RackAwareGraphConstructor {
    @Override
    public int getSinkNodeID(List<TaskId> taskIdList, List<UUID> clientList, Map<TopologyMetadata.Subtopology, Set<TaskId>> tasksForTopicGroup) {
        return clientList.size() + taskIdList.size();
    }

    @Override
    public int getClientNodeId(int clientIndex, List<TaskId> taskIdList, List<UUID> clientList, int topicGroupIndex) {
        return clientIndex + taskIdList.size();
    }

    @Override
    public int getClientIndex(int clientNodeId, List<TaskId> taskIdList, List<UUID> clientList, int topicGroupIndex) {
        return clientNodeId - taskIdList.size();
    }

    @Override
    public Graph<Integer> constructTaskGraph(List<UUID> clientList, List<TaskId> taskIdList, Map<UUID, ClientState> clientStates, Map<TaskId, UUID> taskClientMap, Map<UUID, Integer> originalAssignedTaskNumber, BiPredicate<ClientState, TaskId> hasAssignedTask, RackAwareTaskAssignor.CostFunction costFunction, int trafficCost, int nonOverlapCost, boolean hasReplica, boolean isStandby) {
        Graph<Integer> graph = new Graph<Integer>();
        for (TaskId taskId : taskIdList) {
            for (Map.Entry<UUID, ClientState> clientState : clientStates.entrySet()) {
                if (!hasAssignedTask.test(clientState.getValue(), taskId)) continue;
                originalAssignedTaskNumber.merge(clientState.getKey(), 1, Integer::sum);
            }
        }
        for (int taskNodeId = 0; taskNodeId < taskIdList.size(); ++taskNodeId) {
            TaskId taskId;
            taskId = taskIdList.get(taskNodeId);
            for (int j = 0; j < clientList.size(); ++j) {
                int clientNodeId = this.getClientNodeId(j, taskIdList, null, -1);
                UUID processId = clientList.get(j);
                int flow = hasAssignedTask.test(clientStates.get(processId), taskId) ? 1 : 0;
                int cost = costFunction.getCost(taskId, processId, flow == 1, trafficCost, nonOverlapCost, isStandby);
                if (flow == 1) {
                    if (!hasReplica && taskClientMap.containsKey(taskId)) {
                        throw new IllegalArgumentException("Task " + taskId + " assigned to multiple clients " + processId + ", " + taskClientMap.get(taskId));
                    }
                    taskClientMap.put(taskId, processId);
                }
                graph.addEdge(taskNodeId, clientNodeId, 1, cost, flow);
            }
            if (!taskClientMap.containsKey(taskId)) {
                throw new IllegalArgumentException("Task " + taskId + " not assigned to any client");
            }
            graph.addEdge(-1, taskNodeId, 1, 0, 1);
        }
        int sinkId = this.getSinkNodeID(taskIdList, clientList, null);
        for (int i = 0; i < clientList.size(); ++i) {
            int clientNodeId = this.getClientNodeId(i, taskIdList, null, -1);
            int capacity = originalAssignedTaskNumber.getOrDefault(clientList.get(i), 0);
            graph.addEdge(clientNodeId, sinkId, capacity, 0, capacity);
        }
        graph.setSourceNode(-1);
        graph.setSinkNode(sinkId);
        return graph;
    }

    @Override
    public boolean assignTaskFromMinCostFlow(Graph<Integer> graph, List<UUID> clientList, List<TaskId> taskIdList, Map<UUID, ClientState> clientStates, Map<UUID, Integer> originalAssignedTaskNumber, Map<TaskId, UUID> taskClientMap, BiConsumer<ClientState, TaskId> assignTask, BiConsumer<ClientState, TaskId> unAssignTask, BiPredicate<ClientState, TaskId> hasAssignedTask) {
        int tasksAssigned = 0;
        boolean taskMoved = false;
        for (int taskNodeId = 0; taskNodeId < taskIdList.size(); ++taskNodeId) {
            TaskId taskId = taskIdList.get(taskNodeId);
            KeyValue<Boolean, Integer> movedAndAssigned = this.assignTaskToClient(graph, taskId, taskNodeId, -1, clientStates, clientList, taskIdList, taskClientMap, assignTask, unAssignTask);
            taskMoved |= ((Boolean)movedAndAssigned.key).booleanValue();
            tasksAssigned += ((Integer)movedAndAssigned.value).intValue();
        }
        this.validateAssignedTask(taskIdList, tasksAssigned, clientStates, originalAssignedTaskNumber, hasAssignedTask);
        return taskMoved;
    }
}

