/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;
import org.apache.kafka.streams.kstream.internals.WrappingNullableUtils;
import org.apache.kafka.streams.processor.internals.SerdeGetter;
import org.apache.kafka.streams.state.internals.TimestampedKeyAndJoinSide;

public class TimestampedKeyAndJoinSideDeserializer<K>
implements WrappingNullableDeserializer<TimestampedKeyAndJoinSide<K>, K, Void> {
    private Deserializer<K> keyDeserializer;
    private final Deserializer<Long> timestampDeserializer = new LongDeserializer();

    TimestampedKeyAndJoinSideDeserializer(Deserializer<K> keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    @Override
    public void setIfUnset(SerdeGetter getter) {
        if (this.keyDeserializer == null) {
            this.keyDeserializer = getter.keySerde().deserializer();
        }
        WrappingNullableUtils.initNullableDeserializer(this.keyDeserializer, getter);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.keyDeserializer.configure(configs, isKey);
    }

    public TimestampedKeyAndJoinSide<K> deserialize(String topic, byte[] data) {
        boolean bool = data[8] == 1;
        Object key = this.keyDeserializer.deserialize(topic, this.rawKey(data));
        long timestamp = (Long)this.timestampDeserializer.deserialize(topic, this.rawTimestamp(data));
        return TimestampedKeyAndJoinSide.make(bool, key, timestamp);
    }

    private byte[] rawTimestamp(byte[] data) {
        byte[] rawTimestamp = new byte[8];
        System.arraycopy(data, 0, rawTimestamp, 0, 8);
        return rawTimestamp;
    }

    private byte[] rawKey(byte[] data) {
        byte[] rawKey = new byte[data.length - 8 - 1];
        System.arraycopy(data, 9, rawKey, 0, rawKey.length);
        return rawKey;
    }

    public void close() {
        this.keyDeserializer.close();
    }
}

